/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;

class MXBeanIntrospector
extends MBeanIntrospector<ConvertingMethod> {
    private static final MXBeanIntrospector instance = new MXBeanIntrospector();
    private final MBeanIntrospector.PerInterfaceMap<ConvertingMethod> perInterfaceMap = new MBeanIntrospector.PerInterfaceMap();
    private static final MBeanIntrospector.MBeanInfoMap mbeanInfoMap = new MBeanIntrospector.MBeanInfoMap();

    MXBeanIntrospector() {
    }

    static MXBeanIntrospector getInstance() {
        return instance;
    }

    @Override
    MBeanIntrospector.PerInterfaceMap<ConvertingMethod> getPerInterfaceMap() {
        return this.perInterfaceMap;
    }

    @Override
    MBeanIntrospector.MBeanInfoMap getMBeanInfoMap() {
        return mbeanInfoMap;
    }

    @Override
    MBeanAnalyzer<ConvertingMethod> getAnalyzer(Class<?> clazz) throws NotCompliantMBeanException {
        return MBeanAnalyzer.analyzer(clazz, this);
    }

    @Override
    boolean isMXBean() {
        return true;
    }

    @Override
    ConvertingMethod mFrom(Method method) {
        return ConvertingMethod.from(method);
    }

    @Override
    String getName(ConvertingMethod convertingMethod) {
        return convertingMethod.getName();
    }

    @Override
    Type getGenericReturnType(ConvertingMethod convertingMethod) {
        return convertingMethod.getGenericReturnType();
    }

    @Override
    Type[] getGenericParameterTypes(ConvertingMethod convertingMethod) {
        return convertingMethod.getGenericParameterTypes();
    }

    @Override
    String[] getSignature(ConvertingMethod convertingMethod) {
        return convertingMethod.getOpenSignature();
    }

    @Override
    void checkMethod(ConvertingMethod convertingMethod) {
        convertingMethod.checkCallFromOpen();
    }

    @Override
    Object invokeM2(ConvertingMethod convertingMethod, Object object, Object[] objectArray, Object object2) throws InvocationTargetException, IllegalAccessException, MBeanException {
        return convertingMethod.invokeWithOpenReturn((MXBeanLookup)object2, object, objectArray);
    }

    @Override
    boolean validParameter(ConvertingMethod convertingMethod, Object object, int n, Object object2) {
        Object object3;
        if (object == null) {
            Type type = convertingMethod.getGenericParameterTypes()[n];
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        try {
            object3 = convertingMethod.fromOpenParameter((MXBeanLookup)object2, object, n);
        }
        catch (Exception exception) {
            return true;
        }
        return MXBeanIntrospector.isValidParameter(convertingMethod.getMethod(), object3, n);
    }

    @Override
    MBeanAttributeInfo getMBeanAttributeInfo(String string, ConvertingMethod convertingMethod, ConvertingMethod convertingMethod2) {
        Type type;
        OpenType<?> openType;
        boolean bl = convertingMethod != null;
        boolean bl2 = convertingMethod2 != null;
        boolean bl3 = bl && this.getName(convertingMethod).startsWith("is");
        String string2 = string;
        if (bl) {
            openType = convertingMethod.getOpenReturnType();
            type = convertingMethod.getGenericReturnType();
        } else {
            openType = convertingMethod2.getOpenParameterTypes()[0];
            type = convertingMethod2.getGenericParameterTypes()[0];
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, type);
        if (bl) {
            descriptor = ImmutableDescriptor.union(descriptor, convertingMethod.getDescriptor());
        }
        if (bl2) {
            descriptor = ImmutableDescriptor.union(descriptor, convertingMethod2.getDescriptor());
        }
        MBeanAttributeInfo mBeanAttributeInfo = MXBeanIntrospector.canUseOpenInfo(type) ? new OpenMBeanAttributeInfoSupport(string, string2, openType, bl, bl2, bl3, descriptor) : new MBeanAttributeInfo(string, MXBeanIntrospector.originalTypeString(type), string2, bl, bl2, bl3, descriptor);
        return mBeanAttributeInfo;
    }

    @Override
    MBeanOperationInfo getMBeanOperationInfo(String string, ConvertingMethod convertingMethod) {
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray;
        Object object;
        Method method = convertingMethod.getMethod();
        String string2 = string;
        OpenType<?> openType = convertingMethod.getOpenReturnType();
        Type type = convertingMethod.getGenericReturnType();
        OpenType<?>[] openTypeArray = convertingMethod.getOpenParameterTypes();
        Type[] typeArray = convertingMethod.getGenericParameterTypes();
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[openTypeArray.length];
        boolean bl = MXBeanIntrospector.canUseOpenInfo(type);
        boolean bl2 = true;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        for (int i = 0; i < openTypeArray.length; ++i) {
            MBeanParameterInfo mBeanParameterInfo;
            openMBeanParameterInfoArray = object = "p" + i;
            OpenType<?> openType2 = openTypeArray[i];
            Type type2 = typeArray[i];
            Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType2, type2);
            descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForAnnotations(annotationArray[i]));
            if (MXBeanIntrospector.canUseOpenInfo(type2)) {
                mBeanParameterInfo = new OpenMBeanParameterInfoSupport((String)object, (String)openMBeanParameterInfoArray, openType2, descriptor);
            } else {
                bl2 = false;
                mBeanParameterInfo = new MBeanParameterInfo((String)object, MXBeanIntrospector.originalTypeString(type2), (String)openMBeanParameterInfoArray, descriptor);
            }
            mBeanParameterInfoArray[i] = mBeanParameterInfo;
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, type);
        descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForElement(method));
        if (bl && bl2) {
            openMBeanParameterInfoArray = new OpenMBeanParameterInfo[mBeanParameterInfoArray.length];
            System.arraycopy((Object)mBeanParameterInfoArray, 0, (Object)openMBeanParameterInfoArray, 0, mBeanParameterInfoArray.length);
            object = new OpenMBeanOperationInfoSupport(string, string2, openMBeanParameterInfoArray, openType, 3, descriptor);
        } else {
            object = new MBeanOperationInfo(string, string2, mBeanParameterInfoArray, bl ? openType.getClassName() : MXBeanIntrospector.originalTypeString(type), 3, descriptor);
        }
        return object;
    }

    @Override
    Descriptor getBasicMBeanDescriptor() {
        return new ImmutableDescriptor("mxbean=true", "immutableInfo=true");
    }

    @Override
    Descriptor getMBeanDescriptor(Class<?> clazz) {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    private static Descriptor typeDescriptor(OpenType<?> openType, Type type) {
        return new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, MXBeanIntrospector.originalTypeString(type)});
    }

    private static boolean canUseOpenInfo(Type type) {
        if (type instanceof GenericArrayType) {
            return MXBeanIntrospector.canUseOpenInfo(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return MXBeanIntrospector.canUseOpenInfo(((Class)type).getComponentType());
        }
        return !(type instanceof Class) || !((Class)type).isPrimitive();
    }

    private static String originalTypeString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return MXBeanIntrospector.typeName(type);
    }

    static String typeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return MXBeanIntrospector.typeName(clazz.getComponentType()) + "[]";
            }
            return clazz.getName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return MXBeanIntrospector.typeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MXBeanIntrospector.typeName(parameterizedType.getRawType())).append("<");
            String string = "";
            for (Type type2 : parameterizedType.getActualTypeArguments()) {
                stringBuilder.append(string).append(MXBeanIntrospector.typeName(type2));
                string = ", ";
            }
            return stringBuilder.append(">").toString();
        }
        return "???";
    }
}

