/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class SpreadHandle
extends MethodHandle {
    private final MethodHandle next;
    private final Class<?> arrayClass;
    private final int spreadCount;
    private final int spreadPosition;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected SpreadHandle(MethodHandle methodHandle, MethodType methodType, Class<?> clazz, int n, int n2) {
        super(methodType, (byte)19, SpreadHandle.infoAffectingThunks(clazz, n, n2));
        this.arrayClass = clazz;
        this.spreadCount = n;
        this.spreadPosition = n2;
        this.next = methodHandle;
    }

    SpreadHandle(SpreadHandle spreadHandle, MethodType methodType) {
        super(spreadHandle, methodType);
        this.next = spreadHandle.next;
        this.arrayClass = spreadHandle.arrayClass;
        this.spreadCount = spreadHandle.spreadCount;
        this.spreadPosition = spreadHandle.spreadPosition;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static Object[] infoAffectingThunks(Class<?> clazz, int n, int n2) {
        Object[] objectArray = new Object[]{clazz, n, n2};
        return objectArray;
    }

    @Override
    protected final ThunkTuple computeThunks(Object object) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])object));
    }

    private static native int numArgsToPassThrough();

    private static native int numArgsToSpread();

    private static native int spreadStart();

    private static native int numArgsAfterSpreadArray();

    private static native Object arrayArg(int var0);

    private static void checkCast(Class<?> clazz, Object object) {
        clazz.cast(object);
    }

    private static void checkArray(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            if (n != 0) {
                throw new IllegalArgumentException(Msg.getString("K05d1"));
            }
        } else if (n != Array.getLength(object)) {
            throw new IllegalArgumentException(Msg.getString("K05d2", n, Array.getLength(object)));
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int n) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        SpreadHandle.checkCast(this.arrayClass, SpreadHandle.arrayArg(n));
        SpreadHandle.checkArray(SpreadHandle.arrayArg(n), this.spreadCount);
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(SpreadHandle.spreadStart(), n), ILGenMacros.arrayElements(SpreadHandle.arrayArg(n), 0, SpreadHandle.numArgsToSpread()), ILGenMacros.lastN(SpreadHandle.numArgsAfterSpreadArray(), n)));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new SpreadHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof SpreadHandle) {
            ((SpreadHandle)methodHandle).compareWithSpread(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithSpread(SpreadHandle spreadHandle, Comparator comparator) {
        comparator.compareStructuralParameter(spreadHandle.arrayClass, this.arrayClass);
        comparator.compareStructuralParameter(spreadHandle.spreadCount, this.spreadCount);
        comparator.compareStructuralParameter(spreadHandle.spreadPosition, this.spreadPosition);
        comparator.compareChildHandle(spreadHandle.next, this.next);
    }
}

