/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.AttachmentConnection;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.IbmAttachOperationFailedException;
import openj9.internal.tools.attach.target.Reply;
import openj9.internal.tools.attach.target.Response;
import sun.misc.VMSupport;

final class Attachment
extends Thread
implements Response {
    private Exception lastError;
    private OutputStream responseStream;
    private Socket attacherSocket;
    private final int portNumber;
    private InputStream commandStream;
    private String attachError;
    private final AttachHandler handler;
    private final String key;
    private static final String START_REMOTE_MANAGEMENT_AGENT = "startRemoteManagementAgent";
    private static final String START_LOCAL_MANAGEMENT_AGENT = "startLocalManagementAgent";

    Attachment(AttachHandler attachHandler, Reply reply) {
        this.setName("Attachment " + reply.getPortNumber());
        this.portNumber = reply.getPortNumber();
        this.key = reply.getKey();
        this.handler = attachHandler;
        this.setDaemon(true);
    }

    boolean connectToAttacher(int n) {
        try {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            this.attacherSocket = new Socket(inetAddress, n);
            IPC.logMessage("connectToAttacher localPort=", this.attacherSocket.getLocalPort(), " remotePort=", Integer.toString(this.attacherSocket.getPort()));
            this.responseStream = this.attacherSocket.getOutputStream();
            this.commandStream = this.attacherSocket.getInputStream();
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_CONNECTED " + this.key + ' ');
            return true;
        }
        catch (IOException iOException) {
            IPC.logMessage("connectToAttacher exception " + iOException.getMessage() + " " + iOException.toString());
            Attachment.closeQuietly(this.responseStream);
            Attachment.closeQuietly(this.commandStream);
            Attachment.closeQuietly(this.attacherSocket);
        }
        catch (Exception exception) {
            IPC.logMessage("connectToAttacher exception ", exception.toString());
        }
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        boolean bl = false;
        IPC.logMessage("Attachment run");
        this.connectToAttacher(this.getPortNumber());
        while (!bl && !this.isInterrupted()) {
            bl = this.doCommand(this.commandStream, this.responseStream);
        }
        try {
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_DETACHED");
            if (null != this.responseStream) {
                this.responseStream.close();
                this.responseStream = null;
            }
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
        if (null != this.handler) {
            this.handler.removeAttachment(this);
        }
    }

    boolean doCommand(InputStream inputStream, OutputStream outputStream) {
        block24: {
            try {
                byte[] byArray = AttachmentConnection.streamReceiveBytes(inputStream, true);
                String string = AttachmentConnection.bytesToString(byArray);
                IPC.logMessage("doCommand ", string);
                if (null == string) {
                    return true;
                }
                if (string.startsWith("ATTACH_DETACH")) {
                    return true;
                }
                if (string.startsWith("ATTACH_LOADAGENT")) {
                    if (this.parseLoadAgent(string)) {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ERR " + this.attachError);
                    }
                    break block24;
                }
                if (string.startsWith("ATTACH_GETSYSTEMPROPERTIES")) {
                    Properties properties = VM.getVMLangAccess().internalGetProperties();
                    String string2 = String.join((CharSequence)" ", VM.getVMArgs());
                    Properties properties2 = (Properties)properties.clone();
                    properties2.put("sun.jvm.args", string2);
                    this.replyWithProperties(properties2);
                    break block24;
                }
                if (string.startsWith("ATTACH_GETAGENTPROPERTIES")) {
                    this.replyWithProperties(AttachHandler.getAgentProperties());
                    break block24;
                }
                if (string.startsWith("ATTACH_START_LOCAL_MANAGEMENT_AGENT")) {
                    try {
                        String string3 = Attachment.startLocalAgent();
                        AttachmentConnection.streamSend(outputStream, "ATTACH_RESULT=" + string3);
                        break block24;
                    }
                    catch (IbmAttachOperationFailedException ibmAttachOperationFailedException) {
                        AttachmentConnection.streamSend(outputStream, String.format("%s: %s in startLocalManagementAgent: %s", "ATTACH_ERR", "AttachOperationFailedException", ibmAttachOperationFailedException.toString()));
                        return false;
                    }
                }
                if (string.startsWith("ATTACH_START_MANAGEMENT_AGENT")) {
                    int n;
                    for (n = 0; n < byArray.length && 0 != byArray[n]; ++n) {
                    }
                    Properties properties = null;
                    properties = ++n < byArray.length ? IPC.receiveProperties(new ByteArrayInputStream(byArray, n, byArray.length - n), false) : IPC.receiveProperties(inputStream, true);
                    IPC.logMessage("startAgent:" + string);
                    if (this.startAgent(properties)) {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ERR " + this.attachError);
                    }
                } else if (string.startsWith("ATTACH_DIAGNOSTICS:")) {
                    try {
                        String string4 = string.substring("ATTACH_DIAGNOSTICS:".length());
                        this.replyWithProperties(DiagnosticUtils.executeDiagnosticCommand(string4));
                    }
                    catch (Exception exception) {
                        this.replyWithProperties(DiagnosticProperties.makeExceptionProperties(exception));
                    }
                } else {
                    AttachmentConnection.streamSend(outputStream, "ATTACH_ERR command invalid: " + string);
                }
            }
            catch (IOException iOException) {
                IPC.logMessage("doCommand IOException ", iOException.toString());
                return true;
            }
            catch (Throwable throwable) {
                IPC.logMessage("doCommand exception ", throwable.toString());
                try {
                    AttachmentConnection.streamSend(outputStream, "ATTACH_ERR unexpected exception or error: " + throwable.toString());
                }
                catch (IOException iOException) {
                    IPC.logMessage("IOException sending error response" + iOException.toString());
                }
                return true;
            }
        }
        return false;
    }

    private void replyWithProperties(DiagnosticProperties diagnosticProperties) throws IOException {
        this.replyWithProperties(diagnosticProperties.toProperties());
    }

    private void replyWithProperties(Properties properties) throws IOException {
        IPC.sendProperties(properties, this.responseStream);
    }

    synchronized void teardown() {
        try {
            if (null != this.responseStream) {
                this.responseStream.close();
            }
            if (null != this.attacherSocket) {
                this.attacherSocket.close();
            }
            if (null != this.commandStream) {
                this.commandStream.close();
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
    }

    private boolean parseLoadAgent(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        int n3 = string.indexOf(44);
        String string2 = "";
        boolean bl = true;
        this.attachError = null;
        if (string.startsWith("ATTACH_LOADAGENTPATH")) {
            bl = false;
        }
        if (n < 0 || n2 < 0) {
            this.attachError = "syntax error";
            return false;
        }
        int n4 = n3 < 0 ? n2 : n3;
        String string3 = string.substring(n + 1, n4);
        if (string3.length() < 1) {
            this.attachError = "invalid agent name";
            return false;
        }
        if (n3 > 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        this.attachError = this.loadAgentLibrary(string3, string2, bl);
        return this.attachError == null;
    }

    String loadAgentLibrary(String string, String string2, boolean bl) {
        IPC.logMessage("loadAgentLibrary " + string + ':' + string2 + " decorate=" + bl);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        int n = this.loadAgentLibraryImpl(classLoader, string, string2, bl);
        if (0 != n) {
            if (-1 == n) {
                return "AgentLoadException " + string + ':' + string2;
            }
            return "AgentInitializationException" + n;
        }
        return null;
    }

    private native int loadAgentLibraryImpl(ClassLoader var1, String var2, String var3, boolean var4);

    private int getPortNumber() {
        return this.portNumber;
    }

    private boolean startAgent(Properties properties) {
        try {
            IPC.logMessage("startAgent");
            if (null != MethodRefsHolder.startRemoteManagementAgentMethod) {
                String string = properties.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(","));
                MethodRefsHolder.startRemoteManagementAgentMethod.invoke(null, string);
                return true;
            }
            this.attachError = "NoSuchMethodException: startRemoteManagementAgent";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.attachError = "IllegalArgumentException: " + illegalArgumentException.getMessage();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.attachError = "IllegalAccessException: " + illegalAccessException.getMessage();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.attachError = "InvocationTargetException: " + invocationTargetException.getMessage();
        }
        return false;
    }

    private static String startLocalAgent() throws IbmAttachOperationFailedException {
        IPC.logMessage("startLocalAgent");
        if (null != MethodRefsHolder.startLocalManagementAgentMethod) {
            try {
                MethodRefsHolder.startLocalManagementAgentMethod.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                IPC.logMessage("Exception starting management agent:", throwable);
                throw new IbmAttachOperationFailedException("startLocalManagementAgent error starting agent", throwable);
            }
        } else {
            Throwable throwable = MethodRefsHolder.managementAgentMethodThrowable;
            String string = "Target VM cannot access startLocalManagementAgent";
            IPC.logMessage(string, throwable);
            throw new IbmAttachOperationFailedException(string, throwable);
        }
        String string = Attachment.saveLocalConnectorAddress();
        if (Objects.isNull(string)) {
            throw new IbmAttachOperationFailedException("startLocalManagementAgent: com.sun.management.jmxremote.localConnectorAddress not defined");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String saveLocalConnectorAddress() {
        String string;
        Properties properties;
        Properties properties2 = properties = VM.getVMLangAccess().internalGetProperties();
        synchronized (properties2) {
            string = properties.getProperty("com.sun.management.jmxremote.localConnectorAddress");
            if (Objects.isNull(string) && !Objects.isNull(string = VMSupport.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress"))) {
                properties.setProperty("com.sun.management.jmxremote.localConnectorAddress", string);
            }
        }
        if (Objects.isNull(string)) {
            IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress not set");
            return null;
        }
        IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress=", string);
        return string;
    }

    private static final class MethodRefsHolder {
        static Method startLocalManagementAgentMethod = null;
        static Method startRemoteManagementAgentMethod = null;
        static final Throwable managementAgentMethodThrowable = AccessController.doPrivileged(() -> {
            String string = "sun.management.Agent";
            IPC.logMessage("Loading " + string);
            Throwable throwable = null;
            try {
                Class<?> clazz = null;
                Class<String> clazz2 = null;
                clazz = Class.forName(string);
                clazz2 = String.class;
                startLocalManagementAgentMethod = clazz.getDeclaredMethod(Attachment.START_LOCAL_MANAGEMENT_AGENT, new Class[0]);
                startRemoteManagementAgentMethod = clazz.getDeclaredMethod(Attachment.START_REMOTE_MANAGEMENT_AGENT, clazz2);
                startLocalManagementAgentMethod.setAccessible(true);
                startRemoteManagementAgentMethod.setAccessible(true);
                IPC.logMessage("Loaded " + string);
            }
            catch (Throwable throwable2) {
                IPC.logMessage("Error loading " + string, throwable2);
                throwable = throwable2;
            }
            return throwable;
        });

        private MethodRefsHolder() {
        }
    }
}

