/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import sun.management.GcInfoCompositeData;
import sun.management.Util;

public class GcInfoBuilder {
    private final GarbageCollectorMXBean gc;
    private final String[] poolNames;
    private String[] allItemNames;
    private CompositeType gcInfoCompositeType;
    private final int gcExtItemCount;
    private final String[] gcExtItemNames;
    private final String[] gcExtItemDescs;
    private final char[] gcExtItemTypes;

    GcInfoBuilder(GarbageCollectorMXBean garbageCollectorMXBean, String[] stringArray) {
        this.gc = garbageCollectorMXBean;
        this.poolNames = stringArray;
        this.gcExtItemCount = this.getNumGcExtAttributes(garbageCollectorMXBean);
        this.gcExtItemNames = new String[this.gcExtItemCount];
        this.gcExtItemDescs = new String[this.gcExtItemCount];
        this.gcExtItemTypes = new char[this.gcExtItemCount];
        this.fillGcAttributeInfo(garbageCollectorMXBean, this.gcExtItemCount, this.gcExtItemNames, this.gcExtItemTypes, this.gcExtItemDescs);
        this.gcInfoCompositeType = null;
    }

    GcInfo getLastGcInfo() {
        MemoryUsage[] memoryUsageArray = new MemoryUsage[this.poolNames.length];
        MemoryUsage[] memoryUsageArray2 = new MemoryUsage[this.poolNames.length];
        Object[] objectArray = new Object[this.gcExtItemCount];
        return this.getLastGcInfo0(this.gc, this.gcExtItemCount, objectArray, this.gcExtItemTypes, memoryUsageArray, memoryUsageArray2);
    }

    public String[] getPoolNames() {
        return this.poolNames;
    }

    int getGcExtItemCount() {
        return this.gcExtItemCount;
    }

    synchronized CompositeType getGcInfoCompositeType() {
        if (this.gcInfoCompositeType != null) {
            return this.gcInfoCompositeType;
        }
        String[] stringArray = GcInfoCompositeData.getBaseGcInfoItemNames();
        OpenType[] openTypeArray = GcInfoCompositeData.getBaseGcInfoItemTypes();
        int n = stringArray.length;
        int n2 = n + this.gcExtItemCount;
        this.allItemNames = new String[n2];
        String[] stringArray2 = new String[n2];
        OpenType[] openTypeArray2 = new OpenType[n2];
        System.arraycopy((Object)stringArray, 0, (Object)this.allItemNames, 0, n);
        System.arraycopy((Object)stringArray, 0, (Object)stringArray2, 0, n);
        System.arraycopy((Object)openTypeArray, 0, (Object)openTypeArray2, 0, n);
        if (this.gcExtItemCount > 0) {
            this.fillGcAttributeInfo(this.gc, this.gcExtItemCount, this.gcExtItemNames, this.gcExtItemTypes, this.gcExtItemDescs);
            System.arraycopy((Object)this.gcExtItemNames, 0, (Object)this.allItemNames, n, this.gcExtItemCount);
            System.arraycopy((Object)this.gcExtItemDescs, 0, (Object)stringArray2, n, this.gcExtItemCount);
            int n3 = n;
            for (int i = 0; i < this.gcExtItemCount; ++i) {
                switch (this.gcExtItemTypes[i]) {
                    case 'Z': {
                        openTypeArray2[n3] = SimpleType.BOOLEAN;
                        break;
                    }
                    case 'B': {
                        openTypeArray2[n3] = SimpleType.BYTE;
                        break;
                    }
                    case 'C': {
                        openTypeArray2[n3] = SimpleType.CHARACTER;
                        break;
                    }
                    case 'S': {
                        openTypeArray2[n3] = SimpleType.SHORT;
                        break;
                    }
                    case 'I': {
                        openTypeArray2[n3] = SimpleType.INTEGER;
                        break;
                    }
                    case 'J': {
                        openTypeArray2[n3] = SimpleType.LONG;
                        break;
                    }
                    case 'F': {
                        openTypeArray2[n3] = SimpleType.FLOAT;
                        break;
                    }
                    case 'D': {
                        openTypeArray2[n3] = SimpleType.DOUBLE;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported type [" + this.gcExtItemTypes[n3] + "]"));
                    }
                }
                ++n3;
            }
        }
        CompositeType compositeType = null;
        try {
            String string = "sun.management." + this.gc.getName() + ".GcInfoCompositeType";
            compositeType = new CompositeType(string, "CompositeType for GC info for " + this.gc.getName(), this.allItemNames, stringArray2, openTypeArray2);
        }
        catch (OpenDataException openDataException) {
            throw Util.newException(openDataException);
        }
        this.gcInfoCompositeType = compositeType;
        return this.gcInfoCompositeType;
    }

    synchronized String[] getItemNames() {
        if (this.allItemNames == null) {
            this.getGcInfoCompositeType();
        }
        return this.allItemNames;
    }

    private native int getNumGcExtAttributes(GarbageCollectorMXBean var1);

    private native void fillGcAttributeInfo(GarbageCollectorMXBean var1, int var2, String[] var3, char[] var4, String[] var5);

    private native GcInfo getLastGcInfo0(GarbageCollectorMXBean var1, int var2, Object[] var3, char[] var4, MemoryUsage[] var5, MemoryUsage[] var6);
}

