/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.krb5.WrapToken_v2;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.crypto.Aes128;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.Des3;

class CipherHelper {
    private static final int KG_USAGE_SEAL = 22;
    private static final int KG_USAGE_SIGN = 23;
    private static final int KG_USAGE_SEQ = 24;
    private static final int DES_CHECKSUM_SIZE = 8;
    private static final int DES_IV_SIZE = 8;
    private static final int AES_IV_SIZE = 16;
    private static final int HMAC_CHECKSUM_SIZE = 8;
    private static final int KG_USAGE_SIGN_MS = 15;
    private static final boolean DEBUG = Krb5Util.DEBUG;
    private static final byte[] ZERO_IV = new byte[8];
    private static final byte[] ZERO_IV_AES = new byte[16];
    private int etype;
    private int sgnAlg;
    private int sealAlg;
    private byte[] keybytes;
    private int proto = 0;

    CipherHelper(EncryptionKey encryptionKey) throws GSSException {
        this.etype = encryptionKey.getEType();
        this.keybytes = encryptionKey.getBytes();
        switch (this.etype) {
            case 1: 
            case 3: {
                this.sgnAlg = 0;
                this.sealAlg = 0;
                break;
            }
            case 16: {
                this.sgnAlg = 1024;
                this.sealAlg = 512;
                break;
            }
            case 23: {
                this.sgnAlg = 4352;
                this.sealAlg = 4096;
                break;
            }
            case 17: 
            case 18: {
                this.sgnAlg = -1;
                this.sealAlg = -1;
                this.proto = 1;
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
            }
        }
    }

    int getSgnAlg() {
        return this.sgnAlg;
    }

    int getSealAlg() {
        return this.sealAlg;
    }

    int getProto() {
        return this.proto;
    }

    int getEType() {
        return this.etype;
    }

    boolean isArcFour() {
        boolean bl = false;
        if (this.etype == 23) {
            bl = true;
        }
        return bl;
    }

    byte[] calculateChecksum(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, int n4) throws GSSException {
        switch (n) {
            case 0: {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(byArray);
                    messageDigest.update(byArray3, n2, n3);
                    if (byArray2 != null) {
                        messageDigest.update(byArray2);
                    }
                    byArray3 = messageDigest.digest();
                    n2 = 0;
                    n3 = byArray3.length;
                    byArray = null;
                    byArray2 = null;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not get MD5 Message Digest - " + noSuchAlgorithmException.getMessage());
                    gSSException.initCause(noSuchAlgorithmException);
                    throw gSSException;
                }
            }
            case 512: {
                return this.getDesCbcChecksum(this.keybytes, byArray, byArray3, n2, n3);
            }
            case 1024: {
                int n5;
                int n6;
                byte[] byArray4;
                if (byArray == null && byArray2 == null) {
                    byArray4 = byArray3;
                    n6 = n3;
                    n5 = n2;
                } else {
                    n6 = (byArray != null ? byArray.length : 0) + n3 + (byArray2 != null ? byArray2.length : 0);
                    byArray4 = new byte[n6];
                    int n7 = 0;
                    if (byArray != null) {
                        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
                        n7 = byArray.length;
                    }
                    System.arraycopy((Object)byArray3, n2, (Object)byArray4, n7, n3);
                    n7 += n3;
                    if (byArray2 != null) {
                        System.arraycopy((Object)byArray2, 0, (Object)byArray4, n7, byArray2.length);
                    }
                    n5 = 0;
                }
                try {
                    byte[] byArray5 = Des3.calculateChecksum(this.keybytes, 23, byArray4, n5, n6);
                    return byArray5;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use HMAC-SHA1-DES3-KD signing algorithm - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 4352: {
                int n8;
                int n9;
                int n10;
                byte[] byArray6;
                if (byArray == null && byArray2 == null) {
                    byArray6 = byArray3;
                    n10 = n3;
                    n9 = n2;
                } else {
                    n10 = (byArray != null ? byArray.length : 0) + n3 + (byArray2 != null ? byArray2.length : 0);
                    byArray6 = new byte[n10];
                    n8 = 0;
                    if (byArray != null) {
                        System.arraycopy((Object)byArray, 0, (Object)byArray6, 0, byArray.length);
                        n8 = byArray.length;
                    }
                    System.arraycopy((Object)byArray3, n2, (Object)byArray6, n8, n3);
                    n8 += n3;
                    if (byArray2 != null) {
                        System.arraycopy((Object)byArray2, 0, (Object)byArray6, n8, byArray2.length);
                    }
                    n9 = 0;
                }
                try {
                    n8 = 23;
                    if (n4 == 257) {
                        n8 = 15;
                    }
                    byte[] byArray7 = ArcFourHmac.calculateChecksum(this.keybytes, n8, byArray6, n9, n10);
                    byte[] byArray8 = new byte[this.getChecksumLength()];
                    System.arraycopy((Object)byArray7, 0, (Object)byArray8, 0, byArray8.length);
                    return byArray8;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use HMAC_MD5_ARCFOUR signing algorithm - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] calculateChecksum(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws GSSException {
        int n4 = (byArray != null ? byArray.length : 0) + n2;
        byte[] byArray3 = new byte[n4];
        System.arraycopy((Object)byArray2, n, (Object)byArray3, 0, n2);
        if (byArray != null) {
            System.arraycopy((Object)byArray, 0, (Object)byArray3, n2, byArray.length);
        }
        switch (this.etype) {
            case 17: {
                try {
                    byte[] byArray4 = Aes128.calculateChecksum(this.keybytes, n3, byArray3, 0, n4);
                    return byArray4;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use AES128 signing algorithm - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 18: {
                try {
                    byte[] byArray5 = Aes256.calculateChecksum(this.keybytes, n3, byArray3, 0, n4);
                    return byArray5;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use AES256 signing algorithm - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
    }

    byte[] encryptSeq(byte[] byArray, byte[] byArray2, int n, int n2) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher cipher = this.getInitializedDes(true, this.keybytes, byArray);
                    return cipher.doFinal(byArray2, n, n2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not encrypt sequence number using DES - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 1024: {
                byte[] byArray3;
                if (byArray.length == 8) {
                    byArray3 = byArray;
                } else {
                    byArray3 = new byte[8];
                    System.arraycopy((Object)byArray, 0, (Object)byArray3, 0, 8);
                }
                try {
                    return Des3.encryptRaw(this.keybytes, 24, byArray3, byArray2, n, n2);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not encrypt sequence number using DES3-KD - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
            case 4352: {
                byte[] byArray4;
                if (byArray.length == 8) {
                    byArray4 = byArray;
                } else {
                    byArray4 = new byte[8];
                    System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, 8);
                }
                try {
                    return ArcFourHmac.encryptSeq(this.keybytes, 24, byArray4, byArray2, n, n2);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not encrypt sequence number using RC4-HMAC - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] decryptSeq(byte[] byArray, byte[] byArray2, int n, int n2) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher cipher = this.getInitializedDes(false, this.keybytes, byArray);
                    return cipher.doFinal(byArray2, n, n2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not decrypt sequence number using DES - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 1024: {
                byte[] byArray3;
                if (byArray.length == 8) {
                    byArray3 = byArray;
                } else {
                    byArray3 = new byte[8];
                    System.arraycopy((Object)byArray, 0, (Object)byArray3, 0, 8);
                }
                try {
                    return Des3.decryptRaw(this.keybytes, 24, byArray3, byArray2, n, n2);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not decrypt sequence number using DES3-KD - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
            case 4352: {
                byte[] byArray4;
                if (byArray.length == 8) {
                    byArray4 = byArray;
                } else {
                    byArray4 = new byte[8];
                    System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, 8);
                }
                try {
                    return ArcFourHmac.decryptSeq(this.keybytes, 24, byArray4, byArray2, n, n2);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not decrypt sequence number using RC4-HMAC - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    int getChecksumLength() throws GSSException {
        switch (this.etype) {
            case 1: 
            case 3: {
                return 8;
            }
            case 16: {
                return Des3.getChecksumLength();
            }
            case 17: {
                return Aes128.getChecksumLength();
            }
            case 18: {
                return Aes256.getChecksumLength();
            }
            case 23: {
                return 8;
            }
        }
        throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
    }

    void decryptData(WrapToken wrapToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(wrapToken, CipherHelper.getDesEncryptionKey(this.keybytes), byArray, n, n2, byArray2, n3);
                break;
            }
            case 512: {
                this.des3KdDecrypt(wrapToken, byArray, n, n2, byArray2, n3);
                break;
            }
            case 4096: {
                this.arcFourDecrypt(wrapToken, byArray, n, n2, byArray2, n3);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void decryptData(WrapToken_v2 wrapToken_v2, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws GSSException {
        switch (this.etype) {
            case 17: {
                this.aes128Decrypt(wrapToken_v2, byArray, n, n2, byArray2, n3, n4);
                break;
            }
            case 18: {
                this.aes256Decrypt(wrapToken_v2, byArray, n, n2, byArray2, n3, n4);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
    }

    void decryptData(WrapToken wrapToken, InputStream inputStream, int n, byte[] byArray, int n2) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(wrapToken, CipherHelper.getDesEncryptionKey(this.keybytes), inputStream, n, byArray, n2);
                break;
            }
            case 512: {
                byte[] byArray2 = new byte[n];
                try {
                    Krb5Token.readFully(inputStream, byArray2, 0, n);
                }
                catch (IOException iOException) {
                    GSSException gSSException = new GSSException(10, -1, "Cannot read complete token");
                    gSSException.initCause(iOException);
                    throw gSSException;
                }
                this.des3KdDecrypt(wrapToken, byArray2, 0, n, byArray, n2);
                break;
            }
            case 4096: {
                byte[] byArray3 = new byte[n];
                try {
                    Krb5Token.readFully(inputStream, byArray3, 0, n);
                }
                catch (IOException iOException) {
                    GSSException gSSException = new GSSException(10, -1, "Cannot read complete token");
                    gSSException.initCause(iOException);
                    throw gSSException;
                }
                this.arcFourDecrypt(wrapToken, byArray3, 0, n, byArray, n2);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void decryptData(WrapToken_v2 wrapToken_v2, InputStream inputStream, int n, byte[] byArray, int n2, int n3) throws GSSException, IOException {
        byte[] byArray2 = new byte[n];
        try {
            Krb5Token.readFully(inputStream, byArray2, 0, n);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(10, -1, "Cannot read complete token");
            gSSException.initCause(iOException);
            throw gSSException;
        }
        switch (this.etype) {
            case 17: {
                this.aes128Decrypt(wrapToken_v2, byArray2, 0, n, byArray, n2, n3);
                break;
            }
            case 18: {
                this.aes256Decrypt(wrapToken_v2, byArray2, 0, n, byArray, n2, n3);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
    }

    void encryptData(WrapToken wrapToken, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, OutputStream outputStream) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                Cipher cipher = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
                cipherOutputStream.write(byArray);
                cipherOutputStream.write(byArray2, n, n2);
                cipherOutputStream.write(byArray3);
                break;
            }
            case 512: {
                byte[] byArray4 = this.des3KdEncrypt(byArray, byArray2, n, n2, byArray3);
                outputStream.write(byArray4);
                break;
            }
            case 4096: {
                byte[] byArray5 = this.arcFourEncrypt(wrapToken, byArray, byArray2, n, n2, byArray3);
                outputStream.write(byArray5);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    byte[] encryptData(WrapToken_v2 wrapToken_v2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) throws GSSException {
        switch (this.etype) {
            case 17: {
                return this.aes128Encrypt(byArray, byArray2, byArray3, n, n2, n3);
            }
            case 18: {
                return this.aes256Encrypt(byArray, byArray2, byArray3, n, n2, n3);
            }
        }
        throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
    }

    void encryptData(WrapToken wrapToken, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, byte[] byArray4, int n3) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                int n4 = n3;
                Cipher cipher = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                try {
                    n4 += cipher.update(byArray, 0, byArray.length, byArray4, n4);
                    n4 += cipher.update(byArray2, n, n2, byArray4, n4);
                    cipher.update(byArray3, 0, byArray3.length, byArray4, n4);
                    cipher.doFinal();
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 512: {
                byte[] byArray5 = this.des3KdEncrypt(byArray, byArray2, n, n2, byArray3);
                System.arraycopy((Object)byArray5, 0, (Object)byArray4, n3, byArray5.length);
                break;
            }
            case 4096: {
                byte[] byArray6 = this.arcFourEncrypt(wrapToken, byArray, byArray2, n, n2, byArray3);
                System.arraycopy((Object)byArray6, 0, (Object)byArray4, n3, byArray6.length);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    int encryptData(WrapToken_v2 wrapToken_v2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, byte[] byArray4, int n3, int n4) throws GSSException {
        byte[] byArray5 = null;
        switch (this.etype) {
            case 17: {
                byArray5 = this.aes128Encrypt(byArray, byArray2, byArray3, n, n2, n4);
                break;
            }
            case 18: {
                byArray5 = this.aes256Encrypt(byArray, byArray2, byArray3, n, n2, n4);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
        System.arraycopy((Object)byArray5, 0, (Object)byArray4, n3, byArray5.length);
        return byArray5.length;
    }

    private byte[] getDesCbcChecksum(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws GSSException {
        Cipher cipher = this.getInitializedDes(true, byArray, ZERO_IV);
        int n3 = cipher.getBlockSize();
        byte[] byArray4 = new byte[n3];
        int n4 = n2 / n3;
        int n5 = n2 % n3;
        if (n5 == 0) {
            System.arraycopy((Object)byArray3, n + --n4 * n3, (Object)byArray4, 0, n3);
        } else {
            System.arraycopy((Object)byArray3, n + n4 * n3, (Object)byArray4, 0, n5);
        }
        try {
            byte[] byArray5 = new byte[Math.max(n3, byArray2 == null ? n3 : byArray2.length)];
            if (byArray2 != null) {
                cipher.update(byArray2, 0, byArray2.length, byArray5, 0);
            }
            for (int i = 0; i < n4; ++i) {
                cipher.update(byArray3, n, n3, byArray5, 0);
                n += n3;
            }
            byte[] byArray6 = new byte[n3];
            cipher.update(byArray4, 0, n3, byArray6, 0);
            cipher.doFinal();
            return byArray6;
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private final Cipher getInitializedDes(boolean bl, byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "DES");
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            cipher.init(bl ? 1 : 2, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private void desCbcDecrypt(WrapToken wrapToken, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws GSSException {
        try {
            int n4 = 0;
            Cipher cipher = this.getInitializedDes(false, byArray, ZERO_IV);
            n4 = cipher.update(byArray2, n, 8, wrapToken.confounder);
            n += 8;
            int n5 = cipher.getBlockSize();
            int n6 = (n2 -= 8) / n5 - 1;
            for (int i = 0; i < n6; ++i) {
                n4 = cipher.update(byArray2, n, n5, byArray3, n3);
                n += n5;
                n3 += n5;
            }
            byte[] byArray4 = new byte[n5];
            cipher.update(byArray2, n, n5, byArray4);
            cipher.doFinal();
            byte by = byArray4[n5 - 1];
            if (by < 1 || by > 8) {
                throw new GSSException(10, -1, "Invalid padding on Wrap Token");
            }
            wrapToken.padding = WrapToken.pads[by];
            System.arraycopy((Object)byArray4, 0, (Object)byArray3, n3, n5 -= by);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private void desCbcDecrypt(WrapToken wrapToken, byte[] byArray, InputStream inputStream, int n, byte[] byArray2, int n2) throws GSSException, IOException {
        int n3 = 0;
        Cipher cipher = this.getInitializedDes(false, byArray, ZERO_IV);
        WrapTokenInputStream wrapTokenInputStream = new WrapTokenInputStream(inputStream, n);
        CipherInputStream cipherInputStream = new CipherInputStream(wrapTokenInputStream, cipher);
        n3 = cipherInputStream.read(wrapToken.confounder);
        int n4 = cipher.getBlockSize();
        int n5 = (n -= n3) / n4 - 1;
        for (int i = 0; i < n5; ++i) {
            n3 = cipherInputStream.read(byArray2, n2, n4);
            n2 += n4;
        }
        byte[] byArray3 = new byte[n4];
        n3 = cipherInputStream.read(byArray3);
        try {
            cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        byte by = byArray3[n4 - 1];
        if (by < 1 || by > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        wrapToken.padding = WrapToken.pads[by];
        System.arraycopy((Object)byArray3, 0, (Object)byArray2, n2, n4 -= by);
    }

    private static byte[] getDesEncryptionKey(byte[] byArray) throws GSSException {
        if (byArray.length > 8) {
            throw new GSSException(11, -100, "Invalid DES Key!");
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ 0xF0);
        }
        return byArray2;
    }

    private void des3KdDecrypt(WrapToken wrapToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws GSSException {
        byte[] byArray3;
        try {
            byArray3 = Des3.decryptRaw(this.keybytes, 22, ZERO_IV, byArray, n, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        byte by = byArray3[byArray3.length - 1];
        if (by < 1 || by > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        wrapToken.padding = WrapToken.pads[by];
        int n4 = byArray3.length - 8 - by;
        System.arraycopy((Object)byArray3, 8, (Object)byArray2, n3, n4);
        System.arraycopy((Object)byArray3, 0, (Object)wrapToken.confounder, 0, 8);
    }

    private byte[] des3KdEncrypt(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) throws GSSException {
        byte[] byArray4 = new byte[byArray.length + n2 + byArray3.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
        System.arraycopy((Object)byArray2, n, (Object)byArray4, byArray.length, n2);
        System.arraycopy((Object)byArray3, 0, (Object)byArray4, byArray.length + n2, byArray3.length);
        try {
            byte[] byArray5 = Des3.encryptRaw(this.keybytes, 22, ZERO_IV, byArray4, 0, byArray4.length);
            return byArray5;
        }
        catch (Exception exception) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + exception.getMessage());
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    private void arcFourDecrypt(WrapToken wrapToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws GSSException {
        byte[] byArray3;
        byte[] byArray4 = this.decryptSeq(wrapToken.getChecksum(), wrapToken.getEncSeqNumber(), 0, 8);
        try {
            byArray3 = ArcFourHmac.decryptRaw(this.keybytes, 22, ZERO_IV, byArray, n, n2, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use ArcFour Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        byte by = byArray3[byArray3.length - 1];
        if (by < 1) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        wrapToken.padding = WrapToken.pads[by];
        int n4 = byArray3.length - 8 - by;
        System.arraycopy((Object)byArray3, 8, (Object)byArray2, n3, n4);
        System.arraycopy((Object)byArray3, 0, (Object)wrapToken.confounder, 0, 8);
    }

    private byte[] arcFourEncrypt(WrapToken wrapToken, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) throws GSSException {
        byte[] byArray4 = new byte[byArray.length + n2 + byArray3.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
        System.arraycopy((Object)byArray2, n, (Object)byArray4, byArray.length, n2);
        System.arraycopy((Object)byArray3, 0, (Object)byArray4, byArray.length + n2, byArray3.length);
        byte[] byArray5 = new byte[4];
        WrapToken.writeBigEndian(wrapToken.getSequenceNumber(), byArray5);
        try {
            byte[] byArray6 = ArcFourHmac.encryptRaw(this.keybytes, 22, byArray5, byArray4, 0, byArray4.length);
            return byArray6;
        }
        catch (Exception exception) {
            GSSException gSSException = new GSSException(11, -1, "Could not use ArcFour Cipher - " + exception.getMessage());
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    private byte[] aes128Encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) throws GSSException {
        byte[] byArray4 = new byte[byArray.length + n2 + byArray2.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
        System.arraycopy((Object)byArray3, n, (Object)byArray4, byArray.length, n2);
        System.arraycopy((Object)byArray2, 0, (Object)byArray4, byArray.length + n2, byArray2.length);
        try {
            byte[] byArray5 = Aes128.encryptRaw(this.keybytes, n3, ZERO_IV_AES, byArray4, 0, byArray4.length);
            return byArray5;
        }
        catch (Exception exception) {
            GSSException gSSException = new GSSException(11, -1, "Could not use AES128 Cipher - " + exception.getMessage());
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    private void aes128Decrypt(WrapToken_v2 wrapToken_v2, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws GSSException {
        byte[] byArray3 = null;
        try {
            byArray3 = Aes128.decryptRaw(this.keybytes, n4, ZERO_IV_AES, byArray, n, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use AES128 Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        int n5 = byArray3.length - 16 - 16;
        System.arraycopy((Object)byArray3, 16, (Object)byArray2, n3, n5);
    }

    private byte[] aes256Encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) throws GSSException {
        byte[] byArray4 = new byte[byArray.length + n2 + byArray2.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
        System.arraycopy((Object)byArray3, n, (Object)byArray4, byArray.length, n2);
        System.arraycopy((Object)byArray2, 0, (Object)byArray4, byArray.length + n2, byArray2.length);
        try {
            byte[] byArray5 = Aes256.encryptRaw(this.keybytes, n3, ZERO_IV_AES, byArray4, 0, byArray4.length);
            return byArray5;
        }
        catch (Exception exception) {
            GSSException gSSException = new GSSException(11, -1, "Could not use AES256 Cipher - " + exception.getMessage());
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    private void aes256Decrypt(WrapToken_v2 wrapToken_v2, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws GSSException {
        byte[] byArray3;
        try {
            byArray3 = Aes256.decryptRaw(this.keybytes, n4, ZERO_IV_AES, byArray, n, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use AES128 Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        int n5 = byArray3.length - 16 - 16;
        System.arraycopy((Object)byArray3, 16, (Object)byArray2, n3, n5);
    }

    class WrapTokenInputStream
    extends InputStream {
        private InputStream is;
        private int length;
        private int remaining;
        private int temp;

        public WrapTokenInputStream(InputStream inputStream, int n) {
            this.is = inputStream;
            this.length = n;
            this.remaining = n;
        }

        @Override
        public final int read() throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = this.is.read();
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        @Override
        public final int read(byte[] byArray) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, byArray.length);
            this.temp = this.is.read(byArray, 0, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, n2);
            this.temp = this.is.read(byArray, n, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        @Override
        public final long skip(long l) throws IOException {
            if (this.remaining == 0) {
                return 0L;
            }
            this.temp = (int)Math.min((long)this.remaining, l);
            this.temp = (int)this.is.skip(this.temp);
            this.remaining -= this.temp;
            return this.temp;
        }

        @Override
        public final int available() throws IOException {
            return Math.min(this.remaining, this.is.available());
        }

        @Override
        public final void close() throws IOException {
            this.remaining = 0;
        }
    }
}

