/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.J9FileImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.MultipleCandidateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class ImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    private static final String FACTORY_DTFJ = "com.ibm.dtfj.image.j9.DTFJImageFactory";
    private static final String FACTORY_DDR = "com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory";
    private final ArrayList<Exception> exceptions = new ArrayList();
    private final Logger log = Logger.getLogger("com.ibm.dtfj.log");
    private ClassLoader imageFactoryClassLoader;
    private File tmpdir = null;

    @Override
    public Image[] getImagesFromArchive(File file, boolean bl) throws IOException {
        Objects.requireNonNull(file);
        if (!FileManager.fileExists(file)) {
            throw new FileNotFoundException("Archive '" + file.getAbsolutePath() + "' not found.");
        }
        if (!FileManager.isArchive(file)) {
            throw new IOException("The specified archive " + file.getAbsolutePath() + " was not recognised");
        }
        ArrayList<Image> arrayList = new ArrayList<Image>();
        this.exceptions.clear();
        CompressedFileManager compressedFileManager = (CompressedFileManager)FileManager.getManager(file);
        List<ManagedImageSource> list = compressedFileManager.getImageSources();
        if (bl) {
            File file2 = ImageFactory.getTempDirParent();
            this.tmpdir = FileManager.createTempDir(file2);
        }
        for (ManagedImageSource managedImageSource : list) {
            Object object;
            Object object2;
            ImageInputStream imageInputStream = null;
            ImageInputStream imageInputStream2 = null;
            if (bl) {
                compressedFileManager.extract(managedImageSource, this.tmpdir);
                object2 = new File(managedImageSource.getPathToExtractedFile());
                imageInputStream = new J9FileImageInputStream((File)object2, managedImageSource);
                if (managedImageSource.hasMetaData()) {
                    compressedFileManager.extract(managedImageSource.getMetadata(), this.tmpdir);
                    object = new File(managedImageSource.getMetadata().getPathToExtractedFile());
                    imageInputStream2 = new J9FileImageInputStream((File)object, managedImageSource.getMetadata());
                }
            } else {
                imageInputStream = compressedFileManager.getStream(managedImageSource);
                if (managedImageSource.hasMetaData()) {
                    imageInputStream2 = compressedFileManager.getStream(managedImageSource.getMetadata());
                }
            }
            try {
                object2 = new ImageReference();
                object = managedImageSource.getType().getFactoryNames();
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string = object[i];
                    if (this.foundRuntimeInImage(string, (ImageReference)object2, managedImageSource.toURI(), imageInputStream, imageInputStream2)) {
                        if (((ImageReference)object2).image instanceof ManagedImage) {
                            ((ManagedImage)((ImageReference)object2).image).setImageSource(managedImageSource);
                        }
                        arrayList.add(((ImageReference)object2).image);
                        break;
                    }
                    ((ImageReference)object2).image = null;
                }
                if (((ImageReference)object2).image != null || !managedImageSource.getType().equals((Object)ImageSourceType.CORE) || (object = this.createImageFactory(FACTORY_DDR)) == null) continue;
                ((ImageReference)object2).image = object.getImage(imageInputStream, managedImageSource.toURI());
                if (((ImageReference)object2).image == null) continue;
                arrayList.add(((ImageReference)object2).image);
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
            }
        }
        this.printExceptions();
        return arrayList.toArray(new Image[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Image getImage(File file) throws IOException {
        Objects.requireNonNull(file);
        ImageReference imageReference = new ImageReference();
        if (!FileManager.fileExists(file)) {
            throw new FileNotFoundException("Image file '" + file.getAbsolutePath() + "' not found.");
        }
        this.exceptions.clear();
        FileManager fileManager = FileManager.getManager(file);
        List<ManagedImageSource> list = fileManager.getImageSources();
        ManagedImageSource managedImageSource = null;
        File file2 = null;
        File file3 = null;
        if (FileManager.isArchive(file)) {
            boolean bl = false;
            CompressedFileManager compressedFileManager = (CompressedFileManager)fileManager;
            for (ManagedImageSource managedImageSource2 : list) {
                if (!managedImageSource2.getType().equals((Object)ImageSourceType.CORE)) continue;
                if (bl) {
                    throw new MultipleCandidateException(list, file);
                }
                managedImageSource = managedImageSource2;
                bl = true;
            }
            if (!bl) throw new IOException("No core files were detected in " + file.getAbsolutePath());
            File file4 = ImageFactory.getTempDirParent();
            this.tmpdir = FileManager.createTempDir(file4);
            compressedFileManager.extract(managedImageSource, this.tmpdir);
            file2 = managedImageSource.getExtractedTo();
            if (managedImageSource.hasMetaData()) {
                compressedFileManager.extract(managedImageSource.getMetadata(), this.tmpdir);
                file3 = managedImageSource.getType().equals((Object)ImageSourceType.CORE) ? file : managedImageSource.getMetadata().getExtractedTo();
            }
        } else {
            if (list.size() > 1) {
                throw new MultipleCandidateException(list, file);
            }
            managedImageSource = list.get(0);
            file2 = new File(managedImageSource.getPath());
            if (managedImageSource.hasMetaData()) {
                file3 = new File(managedImageSource.getMetadata().getPath());
            }
        }
        for (String string : managedImageSource.getType().getFactoryNames()) {
            if (!this.foundImage(string, imageReference, file2, file3)) continue;
            if (!(imageReference.image instanceof ManagedImage)) return imageReference.image;
            ((ManagedImage)imageReference.image).setImageSource(managedImageSource);
            return imageReference.image;
        }
        this.printExceptions();
        if (!managedImageSource.getType().equals((Object)ImageSourceType.CORE)) throw new IOException("The file " + file.getAbsolutePath() + " was not recognised by any reader");
        com.ibm.dtfj.image.ImageFactory imageFactory = this.createImageFactory(FACTORY_DDR);
        if (null != imageFactory) return imageFactory.getImage(file);
        throw this.propagateIOException("Could not create a valid ImageFactory");
    }

    @Override
    public Image getImage(ImageInputStream imageInputStream, URI uRI) throws IOException {
        return this.getImage(imageInputStream, null, uRI);
    }

    @Override
    public Image getImage(ImageInputStream imageInputStream, ImageInputStream imageInputStream2, URI uRI) throws IOException {
        ImageReference imageReference = new ImageReference();
        com.ibm.dtfj.image.ImageFactory imageFactory = null;
        this.exceptions.clear();
        if (this.foundRuntimeInImage(FACTORY_DDR, imageReference, uRI, imageInputStream, imageInputStream2)) {
            return imageReference.image;
        }
        if (this.foundRuntimeInImage(FACTORY_DTFJ, imageReference, uRI, imageInputStream, imageInputStream2)) {
            return imageReference.image;
        }
        imageFactory = this.createImageFactory(FACTORY_DDR);
        this.printExceptions();
        if (null == imageFactory) {
            throw this.propagateIOException("Could not create a valid ImageFactory");
        }
        return imageFactory.getImage(imageInputStream, imageInputStream2, uRI);
    }

    private static File getTempDirParent() {
        String string = System.getProperty("com.ibm.java.diagnostic.tmpdir");
        if (string == null) {
            return new File(System.getProperty("java.io.tmpdir"));
        }
        return new File(string);
    }

    @Override
    public Image getImage(File file, File file2) throws IOException {
        Objects.requireNonNull(file);
        if (file2 != null && !file2.exists()) {
            throw new FileNotFoundException("Metadata file '" + file2.getAbsolutePath() + "' not found.");
        }
        if (!FileManager.fileExists(file)) {
            throw new FileNotFoundException("Image file '" + file.getAbsolutePath() + "' not found.");
        }
        ImageReference imageReference = new ImageReference();
        com.ibm.dtfj.image.ImageFactory imageFactory = null;
        this.exceptions.clear();
        if (null != file2) {
            if (this.foundImage(FACTORY_DTFJ, imageReference, file, file2)) {
                return imageReference.image;
            }
            if (this.foundImage(FACTORY_DDR, imageReference, file, file2)) {
                return imageReference.image;
            }
        } else {
            if (this.foundImage(FACTORY_DDR, imageReference, file, null)) {
                return imageReference.image;
            }
            if (this.foundImage(FACTORY_DTFJ, imageReference, file, null)) {
                return imageReference.image;
            }
        }
        imageFactory = this.createImageFactory(FACTORY_DDR);
        this.printExceptions();
        if (null == imageFactory) {
            throw this.propagateIOException("Could not create a valid ImageFactory");
        }
        return imageFactory.getImage(file);
    }

    private void printExceptions() {
        if (0 == this.exceptions.size()) {
            return;
        }
        this.log.fine("Warning : errors encountered whilst creating ImageFactory");
        for (int i = 0; i < this.exceptions.size(); ++i) {
            Exception exception = this.exceptions.get(i);
            if (!(exception instanceof Exception)) continue;
            Exception exception2 = exception;
            this.log.log(Level.FINE, exception2.getMessage(), exception2);
        }
    }

    private IOException propagateIOException(String string) throws IOException {
        if (this.exceptions.size() == 1 && this.exceptions.get(0) instanceof IOException) {
            throw (IOException)this.exceptions.get(0);
        }
        throw new IOException(string);
    }

    private boolean foundImage(String string, ImageReference imageReference, File file, File file2) {
        try {
            com.ibm.dtfj.image.ImageFactory imageFactory = this.createImageFactory(string);
            if (null == imageFactory) {
                return false;
            }
            imageReference.image = file2 == null ? imageFactory.getImage(file) : imageFactory.getImage(file, file2);
            boolean bl = ImageFactory.hasJavaRuntime(imageReference);
            if (!bl && imageReference.image != null) {
                imageReference.image.close();
            }
            return bl;
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
            return false;
        }
    }

    private boolean foundRuntimeInImage(String string, ImageReference imageReference, URI uRI, ImageInputStream imageInputStream, ImageInputStream imageInputStream2) {
        try {
            com.ibm.dtfj.image.ImageFactory imageFactory = this.createImageFactory(string);
            if (null == imageFactory) {
                return false;
            }
            imageReference.image = imageInputStream2 == null ? imageFactory.getImage(imageInputStream, uRI) : imageFactory.getImage(imageInputStream, imageInputStream2, uRI);
            return ImageFactory.hasJavaRuntime(imageReference);
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
            return false;
        }
    }

    private com.ibm.dtfj.image.ImageFactory createImageFactory(String string) {
        if (this.imageFactoryClassLoader == null) {
            this.initClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(string, true, this.imageFactoryClassLoader);
            Object obj = clazz.newInstance();
            if (obj instanceof com.ibm.dtfj.image.ImageFactory) {
                return (com.ibm.dtfj.image.ImageFactory)obj;
            }
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
        }
        return null;
    }

    private static boolean hasJavaRuntime(ImageReference imageReference) {
        if (null == imageReference || null == imageReference.image) {
            return false;
        }
        Iterator iterator = imageReference.image.getAddressSpaces();
        while (null != iterator && iterator.hasNext()) {
            Object e = iterator.next();
            if (null == e || !(e instanceof ImageAddressSpace)) continue;
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)e;
            Iterator iterator2 = imageAddressSpace.getProcesses();
            while (null != iterator2 && iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (null == e2 || !(e2 instanceof ImageProcess)) continue;
                ImageProcess imageProcess = (ImageProcess)e2;
                Iterator iterator3 = imageProcess.getRuntimes();
                while (null != iterator3 && iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (null == e3 || !(e3 instanceof JavaRuntime)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getDTFJMajorVersion() {
        return 1;
    }

    @Override
    public int getDTFJMinorVersion() {
        return 12;
    }

    @Override
    public int getDTFJModificationLevel() {
        return 29003;
    }

    private void initClassLoader() {
        File file = null;
        String string = System.getProperty("com.ibm.java.diagnostics.ddr.home");
        file = string != null ? new File(string) : new File(System.getProperty("java.home", ""), "lib/ddr");
        if (file.isDirectory()) {
            File[] fileArray = null;
            JarFilter jarFilter = new JarFilter();
            fileArray = file.listFiles(jarFilter);
            URL[] uRLArray = new URL[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    uRLArray[i] = fileArray[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    this.exceptions.add(malformedURLException);
                }
            }
            this.imageFactoryClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        } else {
            this.imageFactoryClassLoader = this.getClass().getClassLoader();
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.regionMatches(true, string.length() - 4, ".jar", 0, 4);
        }
    }

    static final class ImageReference {
        Image image;

        ImageReference() {
        }
    }
}

