/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.classloader;

import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.ClassLoaderPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.IClassLoaderTypes;

public class ClassLoaderSectionParser
extends SectionParser
implements IClassLoaderTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public ClassLoaderSectionParser() {
        super("CLASSES");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.classLoaderSummaries();
        this.classLoaderLibraries();
        this.classLoaders();
    }

    private void classLoaderSummaries() throws ParserException {
        this.processTagLineRequired("1CLTEXTCLLOS");
        this.processTagLineRequired("1CLTEXTCLLSS");
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineRequired("2CLTEXTCLLOADER");
        if (iAttributeValueMap != null) {
            this.processClassLoaderStats(iAttributeValueMap);
            while ((iAttributeValueMap = this.processTagLineOptional("2CLTEXTCLLOADER")) != null) {
                this.processClassLoaderStats(iAttributeValueMap);
            }
        }
    }

    private void classLoaderLibraries() throws ParserException {
        if (this.matchOptional("1CLTEXTCLLIB")) {
            this.consume();
            IParserToken iParserToken = this.lookAhead(1);
            if (iParserToken != null && iParserToken.getType().equals("UNPARSED")) {
                this.consume();
            }
            IAttributeValueMap iAttributeValueMap = null;
            iAttributeValueMap = this.processTagLineRequired("2CLTEXTCLLIB");
            if (iAttributeValueMap != null) {
                this.processLibraryLoader(iAttributeValueMap);
                while ((iAttributeValueMap = this.processTagLineOptional("2CLTEXTCLLIB")) != null) {
                    this.processLibraryLoader(iAttributeValueMap);
                }
            }
        }
    }

    private void classLoaders() throws ParserException {
        this.processTagLineRequired("1CLTEXTCLLOD");
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineRequired("2CLTEXTCLLOAD");
        if (iAttributeValueMap != null) {
            this.processClassLoaders(iAttributeValueMap);
            while ((iAttributeValueMap = this.processTagLineOptional("2CLTEXTCLLOAD")) != null) {
                this.processClassLoaders(iAttributeValueMap);
            }
        }
    }

    private void processClassLoaderStats(IAttributeValueMap iAttributeValueMap) throws ParserException {
        String string = iAttributeValueMap.getTokenValue("cl_name");
        long l = iAttributeValueMap.getLongValue("cl_address");
        long l2 = iAttributeValueMap.getLongValue("cl_shadow_address");
        if (l2 == -1L) {
            l2 = l;
        }
        try {
            this.fRuntimeBuilder.addClassLoader(string, l, l2);
        }
        catch (BuilderFailureException builderFailureException) {
            this.handleError("Failed to add class loader: " + string + " " + l + " ", builderFailureException);
        }
        string = iAttributeValueMap.getTokenValue("cl_parent_name");
        l = iAttributeValueMap.getLongValue("cl_parent_address");
        if (!(string == null && l == -1L || l == 0L && ClassLoaderPatternMatchers.none.reset(string).matches())) {
            try {
                this.fRuntimeBuilder.addClassLoader(string, l, l);
            }
            catch (BuilderFailureException builderFailureException) {
                this.handleError("Failed to add class loader: " + string + " " + l + " ", builderFailureException);
            }
        }
        this.processTagLineOptional("3CLNMBRLOADEDLIB");
        this.processTagLineOptional("3CLNMBRLOADEDCL");
    }

    private void processLibraryLoader(IAttributeValueMap iAttributeValueMap) throws ParserException {
        String string = iAttributeValueMap.getTokenValue("cl_name");
        long l = iAttributeValueMap.getLongValue("cl_address");
        try {
            this.fRuntimeBuilder.addClassLoader(string, l, l);
        }
        catch (BuilderFailureException builderFailureException) {
            this.handleError("Failed to add class loader: " + string + " " + l + " ", builderFailureException);
        }
        iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineRequired("3CLTEXTLIB");
        if (iAttributeValueMap != null) {
            this.fImageProcessBuilder.addLibrary(iAttributeValueMap.getTokenValue("cl_att_lib_name"));
            while ((iAttributeValueMap = this.processTagLineOptional("3CLTEXTLIB")) != null) {
                this.fImageProcessBuilder.addLibrary(iAttributeValueMap.getTokenValue("cl_att_lib_name"));
            }
        }
    }

    private void processClassLoaders(IAttributeValueMap iAttributeValueMap) throws ParserException {
        JavaClassLoader javaClassLoader = null;
        String string = iAttributeValueMap.getTokenValue("cl_name");
        long l = iAttributeValueMap.getLongValue("cl_address");
        try {
            javaClassLoader = this.fRuntimeBuilder.addClassLoader(string, l, l);
        }
        catch (BuilderFailureException builderFailureException) {
            this.handleError("Failed to add class loader: " + string + " " + l + " ", builderFailureException);
        }
        while ((iAttributeValueMap = this.processTagLineOptional("3CLTEXTCLASS")) != null) {
            String string2 = iAttributeValueMap.getTokenValue("class_name");
            long l2 = iAttributeValueMap.getLongValue("class_address");
            try {
                this.fRuntimeBuilder.addClass(javaClassLoader, string2, l2, -1L, null);
            }
            catch (BuilderFailureException builderFailureException) {
                this.handleError("Failed to add class: " + string2 + " " + l2 + " ", builderFailureException);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

