/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;

class PHDJavaReference
implements JavaReference {
    private final Object target;
    private final Object source;
    private final int reach;
    private final int ref;
    private final int root;
    private final String desc;

    PHDJavaReference(Object object, Object object2, int n, int n2, int n3, String string) {
        this.target = object;
        this.source = object2;
        this.reach = n;
        this.ref = n2;
        this.root = n3;
        switch (n2) {
            case 0: {
                string = "Unknown reference";
                break;
            }
            case 1: {
                string = "Class reference";
                break;
            }
            case 2: {
                string = "Field reference";
                break;
            }
            case 3: {
                string = "Array element reference";
                break;
            }
            case 4: {
                string = "Class loader reference";
                break;
            }
            case 5: {
                string = "Signers reference";
                break;
            }
            case 6: {
                string = "Protection domain reference";
                break;
            }
            case 7: {
                string = "Interface reference";
                break;
            }
            case 8: {
                string = "Static field reference";
                break;
            }
            case 9: {
                string = "Constant pool reference";
                break;
            }
            case 10: {
                string = "Superclass reference";
                break;
            }
            case 11: {
                string = "Loaded class reference";
                break;
            }
            case 12: {
                string = "Class object reference";
                break;
            }
            case 13: {
                string = "Associated class reference";
            }
        }
        this.desc = string;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public int getReachability() throws CorruptDataException {
        return this.reach;
    }

    @Override
    public int getReferenceType() throws CorruptDataException {
        return this.ref;
    }

    @Override
    public int getRootType() throws CorruptDataException {
        return this.root;
    }

    @Override
    public Object getSource() throws DataUnavailable, CorruptDataException {
        return this.source;
    }

    @Override
    public Object getTarget() throws DataUnavailable, CorruptDataException {
        return this.target;
    }

    @Override
    public boolean isClassReference() throws DataUnavailable, CorruptDataException {
        return this.target instanceof JavaClass;
    }

    @Override
    public boolean isObjectReference() throws DataUnavailable, CorruptDataException {
        return this.target instanceof JavaObject;
    }

    public boolean equals(Object object) {
        if (object instanceof PHDJavaReference) {
            PHDJavaReference pHDJavaReference = (PHDJavaReference)object;
            if (this.target == pHDJavaReference.target && this.source == pHDJavaReference.source && this.reach == pHDJavaReference.reach && this.ref == pHDJavaReference.ref && this.root == pHDJavaReference.root && (this.getDescription() == null ? pHDJavaReference.getDescription() == null : this.getDescription().equals(pHDJavaReference.getDescription()))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.target != null ? this.target.hashCode() : 0) ^ (this.source != null && this.source != this.target ? this.source.hashCode() : 0) ^ this.reach ^ this.ref ^ this.root ^ (this.getDescription() != null ? this.getDescription().hashCode() : 0);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "," + this.source + "," + this.desc + "]";
    }
}

