/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Container;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Entry {
    protected static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    public static final String FILE_EXT_JAR = ".jar";
    public static final String FILE_EXT_CLASS = ".class";
    private final String name;
    private long lastModified = -1L;
    private long size = -1L;
    private Container parent = null;
    private URL url = null;
    protected File file = null;
    protected Object data = null;

    public Entry(String string) {
        this.name = string;
    }

    public Entry(String string, File file) {
        this(string);
        this.file = file;
        if (file != null) {
            this.size = file.length();
            this.lastModified = file.lastModified();
        }
    }

    public Entry(File file) {
        this(file != null ? file.getName() : "root", file);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public Container getParent() {
        return this.parent;
    }

    public URL toURL() {
        if (this.url == null) {
            if (this.file != null) {
                try {
                    this.url = this.file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    logger.log(Level.FINE, "Exception thrown when constructing URL from file name " + this.file.getAbsolutePath());
                }
            } else if (this.parent != null && this.parent.getName().endsWith(FILE_EXT_JAR)) {
                String string = this.parent.getFile().getAbsolutePath();
                try {
                    this.url = new URL("jar:file:" + string + "!/" + this.name);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.log(Level.FINE, "Exception thrown when constructing URL from jar file name " + string + " and class file name " + this.name);
                }
            }
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasChanged(Entry entry) {
        if (this.file != null ? entry.file == null : !this.name.equals(entry.name)) {
            return false;
        }
        return this.size != entry.size || this.lastModified != entry.lastModified;
    }

    public boolean hasChanged(File file) {
        if (this.file == null) {
            return true;
        }
        if (this.file.equals(file)) {
            return this.size != file.length() || this.lastModified != file.lastModified();
        }
        return true;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Entry)) {
            return false;
        }
        Entry entry = (Entry)object;
        return this.name.equals(entry.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (this.file == null) {
            return this.name;
        }
        return this.name + " loaded from " + this.file.getAbsolutePath();
    }
}

