/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.image.javacore.LookupKey;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaClassLoader;
import com.ibm.dtfj.java.javacore.JCJavaMonitor;
import com.ibm.dtfj.java.javacore.JCJavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import com.ibm.dtfj.java.javacore.JCJavaVMInitArgs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class JCJavaRuntime
implements JavaRuntime {
    private Vector fHeaps;
    private Vector fCompiledMethods;
    private HashMap fJavaClassLoaders;
    private HashMap fJavaClasses;
    private HashMap fMonitors;
    private HashMap fJavaThreads;
    private HashMap fJavaClassIDs;
    private JCJavaVMInitArgs fJavaVMInitArgs;
    private List fMemoryCategories;
    private String fFullVersion;
    private String fVersion;
    private String fID;
    private final LookupKey fIDLookupKey;
    private final JCImageProcess fImageProcess;
    private final JCImageAddressSpace fImageAddressSpace;
    private boolean isJITEnabled = false;
    private Properties jitOptions = new Properties();
    private long fStartTime;
    private boolean fStartTimeSet = false;
    private long fStartTimeNanos;
    private boolean fStartTimeNanosSet = false;

    public JCJavaRuntime(JCImageProcess jCImageProcess, String string) throws JCInvalidArgumentsException {
        if (jCImageProcess == null) {
            throw new JCInvalidArgumentsException("A runtime must be associated with a valid image process");
        }
        if (string == null) {
            throw new JCInvalidArgumentsException("A runtime must be associated with a valid id. This is necessary when parsing multiple runtimes");
        }
        this.fID = string;
        this.fImageProcess = jCImageProcess;
        this.fImageAddressSpace = jCImageProcess.getImageAddressSpace();
        this.fHeaps = new Vector();
        this.fCompiledMethods = new Vector();
        this.fJavaClassLoaders = new LinkedHashMap();
        this.fMonitors = new LinkedHashMap();
        this.fJavaThreads = new LinkedHashMap();
        this.fJavaClasses = new HashMap();
        this.fJavaClassIDs = new HashMap();
        this.fMemoryCategories = new LinkedList();
        this.fFullVersion = null;
        this.fVersion = null;
        this.fIDLookupKey = new LookupKey(-1L);
        jCImageProcess.addRuntime(this);
    }

    @Override
    public Iterator getCompiledMethods() {
        return this.fCompiledMethods.iterator();
    }

    @Override
    public Iterator getHeaps() {
        return this.fHeaps.iterator();
    }

    @Override
    public Iterator getJavaClassLoaders() {
        return this.fJavaClassLoaders.values().iterator();
    }

    @Override
    public Iterator getMonitors() {
        return this.fMonitors.values().iterator();
    }

    @Override
    public Iterator getThreads() {
        return this.fJavaThreads.values().iterator();
    }

    @Override
    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this.fJavaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs not available");
        }
        return this.fJavaVMInitArgs;
    }

    @Override
    public ImagePointer getJavaVM() throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public Object getTraceBuffer(String string, boolean bl) throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public String getFullVersion() throws CorruptDataException {
        if (this.fFullVersion == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fFullVersion;
    }

    @Override
    public String getVersion() throws CorruptDataException {
        if (this.fVersion == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fVersion;
    }

    public String getInternalID() {
        return this.fID;
    }

    public void addJavaClassLoader(JCJavaClassLoader jCJavaClassLoader) throws JCInvalidArgumentsException {
        if (jCJavaClassLoader == null) {
            throw new JCInvalidArgumentsException("Not a valid java class loader.");
        }
        this.fJavaClassLoaders.put(new LookupKey(jCJavaClassLoader.getPointerID().getAddress()), jCJavaClassLoader);
    }

    public JCJavaClassLoader findJavaClassLoader(long l) {
        this.fIDLookupKey.setKey(l);
        return (JCJavaClassLoader)this.fJavaClassLoaders.get(this.fIDLookupKey);
    }

    public void addMonitor(JCJavaMonitor jCJavaMonitor) throws JCInvalidArgumentsException {
        if (jCJavaMonitor == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java monitor");
        }
        this.fMonitors.put(new LookupKey(jCJavaMonitor.getID().getAddress()), jCJavaMonitor);
    }

    public JCJavaMonitor findMonitor(long l) {
        this.fIDLookupKey.setKey(l);
        return (JCJavaMonitor)this.fMonitors.get(this.fIDLookupKey);
    }

    public void addJavaThread(JCJavaThread jCJavaThread) throws JCInvalidArgumentsException {
        if (jCJavaThread == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java thread");
        }
        this.fJavaThreads.put(new LookupKey(jCJavaThread.getThreadID().getAddress()), jCJavaThread);
    }

    public JCJavaThread findJavaThread(long l) {
        JCJavaThread jCJavaThread = null;
        this.fIDLookupKey.setKey(l);
        Object v = this.fJavaThreads.get(this.fIDLookupKey);
        jCJavaThread = (JCJavaThread)v;
        if (v == null) {
            Iterator iterator = this.fJavaThreads.values().iterator();
            while (jCJavaThread == null && iterator.hasNext()) {
                long l2;
                JCJavaThread jCJavaThread2 = (JCJavaThread)iterator.next();
                JCImageThread jCImageThread = jCJavaThread2.internalGetImageThread();
                if (jCImageThread == null) continue;
                ImagePointer imagePointer = jCImageThread.getSystemThreadID();
                long l3 = l2 = imagePointer != null ? imagePointer.getAddress() : -1L;
                if (l2 != -1L && l2 == l) {
                    jCJavaThread = jCJavaThread2;
                    continue;
                }
                imagePointer = jCImageThread.getInternalID();
                if (imagePointer.getAddress() != l) continue;
                jCJavaThread = jCJavaThread2;
            }
        }
        return jCJavaThread;
    }

    public JCImageProcess getImageProcess() {
        return this.fImageProcess;
    }

    public void addJavaClass(JCJavaClass jCJavaClass) throws JCInvalidArgumentsException {
        if (jCJavaClass == null) {
            throw new JCInvalidArgumentsException("Must pass a valid javaClass");
        }
        String string = jCJavaClass.internalGetName();
        ImagePointer imagePointer = jCJavaClass.getID();
        if (imagePointer != null) {
            long l = imagePointer.getAddress();
            this.fJavaClassIDs.put(new LookupKey(l), jCJavaClass);
        }
        this.fJavaClasses.put(string, jCJavaClass);
    }

    public JCJavaClass findJavaClass(String string) {
        return (JCJavaClass)this.fJavaClasses.get(string);
    }

    public JCJavaClass findJavaClass(long l) {
        JCJavaClass jCJavaClass = null;
        if (this.fImageAddressSpace.isValidAddressID(l)) {
            this.fIDLookupKey.setKey(l);
            jCJavaClass = (JCJavaClass)this.fJavaClassIDs.get(this.fIDLookupKey);
        }
        return jCJavaClass;
    }

    public void addJavaVMInitArgs(JCJavaVMInitArgs jCJavaVMInitArgs) throws JCInvalidArgumentsException {
        if (jCJavaVMInitArgs == null) {
            throw new JCInvalidArgumentsException("Must pass a valid JavaVMInitArgs object");
        }
        this.fJavaVMInitArgs = jCJavaVMInitArgs;
    }

    @Override
    public Iterator getHeapRoots() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public JavaObject getObjectAtAddress(ImagePointer imagePointer) throws DataUnavailable {
        throw new DataUnavailable("Object information not available.");
    }

    public void setVersion(String string) {
        this.fVersion = string;
    }

    @Override
    public Iterator getMemoryCategories() throws DataUnavailable {
        return Collections.unmodifiableList(this.fMemoryCategories).iterator();
    }

    @Override
    public Iterator getMemorySections(boolean bl) throws DataUnavailable {
        throw new DataUnavailable("Memory section data not available in JavaCore");
    }

    public void addTopLevelMemoryCategory(JCJavaRuntimeMemoryCategory jCJavaRuntimeMemoryCategory) {
        this.fMemoryCategories.add(jCJavaRuntimeMemoryCategory);
    }

    @Override
    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        return this.isJITEnabled;
    }

    public void setJITEnabled(boolean bl) {
        this.isJITEnabled = bl;
    }

    public void addJITProperty(String string, String string2) {
        this.jitOptions.put(string, string2);
    }

    @Override
    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        if (this.isJITEnabled) {
            return this.jitOptions;
        }
        throw new DataUnavailable("The JIT was not enabled for this runtime");
    }

    @Override
    public long getStartTime() throws DataUnavailable, CorruptDataException {
        if (this.fStartTimeSet) {
            return this.fStartTime;
        }
        throw new DataUnavailable("JVM start time not available");
    }

    @Override
    public long getStartTimeNanos() throws DataUnavailable, CorruptDataException {
        if (this.fStartTimeNanosSet) {
            return this.fStartTimeNanos;
        }
        throw new DataUnavailable("JVM start nanotime not available");
    }

    public void setStartTime(long l) {
        this.fStartTime = l;
        this.fStartTimeSet = true;
    }

    public void setStartTimeNanos(long l) {
        this.fStartTimeNanos = l;
        this.fStartTimeNanosSet = true;
    }
}

