/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadPatternMatchers;
import java.util.regex.Matcher;

public class StackTraceLineRule
extends LineRule {
    private StringBuffer fNameBuffer = new StringBuffer("");

    @Override
    public void processLine(String string, int n) {
        int n2 = n;
        this.consumeUntilFirstMatch(CommonPatternMatchers.at_string);
        this.processMethodAndClassName(n2);
        String string2 = "stacktrace_java_method";
        if (this.consumeUntilFirstMatch(ThreadPatternMatchers.native_method_string)) {
            string2 = "stacktrace_native_method";
        }
        this.addToken("stacktrace_method_type", string2);
        if (string2.equals("stacktrace_java_method") && !this.findFirst(ThreadPatternMatchers.bytecode_pc)) {
            this.addToken("class_file_name", CommonPatternMatchers.java_file_name);
            String string3 = "unknown_comp_lvl";
            if (this.consumeUntilFirstMatch(CommonPatternMatchers.colon)) {
                this.addToken("stacktrace_line_number", CommonPatternMatchers.dec);
            }
            if (this.consumeUntilFirstMatch(ThreadPatternMatchers.compiled_code)) {
                string3 = "compiled";
            }
            this.addToken(TokenManager.getToken(0, n2, this.getLineNumber(), "comp_level", string3));
        }
    }

    private void processMethodAndClassName(int n) {
        Matcher matcher = this.findFirst(CommonPatternMatchers.forward_slash) ? CommonPatternMatchers.java_absolute_method_name : CommonPatternMatchers.java_sov_absolute_method_name;
        String string = this.matchAndConsumeValue(matcher);
        if (string != null) {
            this.fNameBuffer.delete(0, this.fNameBuffer.length());
            this.fNameBuffer.append(string);
            int n2 = 0;
            for (int i = 0; i < this.fNameBuffer.length(); ++i) {
                if (this.fNameBuffer.charAt(i) != '.') continue;
                n2 = i;
                this.fNameBuffer.setCharAt(i, '/');
            }
            if (n2 > 0) {
                String string2 = this.fNameBuffer.substring(0, n2);
                this.addToken("full_location_name", string2);
            }
            if (++n2 < this.fNameBuffer.length()) {
                String string3 = this.fNameBuffer.substring(n2);
                this.addToken("method_name", string3);
            }
        }
    }
}

