/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import com.ibm.java.diagnostics.utils.plugins.DTFJClassListener;
import com.ibm.java.diagnostics.utils.plugins.DTFJPluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginListenerFactory;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DTFJPluginManager {
    private static final String LISTENER_ID = "dtfj.class.listener";
    private Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    public static final String ANNOTATION_CLASSNAME = "Lcom/ibm/java/diagnostics/utils/plugins/DTFJPlugin;";
    private final PluginManager manager;

    public DTFJPluginManager(PluginManager pluginManager) {
        this.manager = pluginManager;
        pluginManager.addListener(new DTFJClassListener(LISTENER_ID));
        String string = System.getProperty("com.ibm.java.diagnostics.plugins.listener");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!PluginListenerFactory.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The class " + string + " specified by the system property " + "com.ibm.java.diagnostics.plugins.listener" + " does not implement " + PluginListenerFactory.class.getName());
                }
                PluginListenerFactory pluginListenerFactory = (PluginListenerFactory)clazz.newInstance();
                Set<ClassListener> set = pluginListenerFactory.getListeners();
                if (set != null) {
                    for (ClassListener classListener : set) {
                        pluginManager.addListener(classListener);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.FINE, "Error occurred loading listener factory, setting is ignored.", exception);
            }
        }
    }

    public List<DTFJPluginConfig> getPlugins(String string, boolean bl, boolean bl2) {
        ArrayList<DTFJPluginConfig> arrayList = new ArrayList<DTFJPluginConfig>();
        for (ClassListener classListener : this.manager.getListeners()) {
            this.setAvailablePlugins(arrayList, classListener.getPluginList(), string, bl, bl2);
        }
        return arrayList;
    }

    private void setAvailablePlugins(List<DTFJPluginConfig> list, Set<PluginConfig> set, String string, boolean bl, boolean bl2) {
        if (set == null) {
            return;
        }
        for (PluginConfig pluginConfig : set) {
            DTFJPluginConfig dTFJPluginConfig;
            Pattern pattern;
            Matcher matcher;
            if (!(pluginConfig instanceof DTFJPluginConfig) || !(matcher = (pattern = Pattern.compile((dTFJPluginConfig = (DTFJPluginConfig)pluginConfig).getVersion())).matcher(string)).matches() || dTFJPluginConfig.isRuntime() && !bl2 || dTFJPluginConfig.isImage() && !bl) continue;
            list.add(dTFJPluginConfig);
        }
    }
}

