/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.vm.ORBBase;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;

public class ORBVMHelpers {
    static Unsafe unsafe = ORBVMHelpers.createUnsafe();

    static Unsafe createUnsafe() {
        return (Unsafe)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        });
    }

    @CallerSensitive
    public static native ClassLoader LatestUserDefinedLoader();

    private static native boolean is32Bit();

    private static native int getNumBitsInReferenceField();

    private static native int getNumBytesInReferenceField();

    private static native int getNumBitsInDescriptionWord();

    private static native int getNumBytesInDescriptionWord();

    private static native int getNumBytesInJ9ObjectHeader();

    private static native int getJ9ClassFromClass32(Class var0);

    private static native int getTotalInstanceSizeFromJ9Class32(int var0);

    private static native int getInstanceDescriptionFromJ9Class32(int var0);

    private static native int getDescriptionWordFromPtr32(int var0);

    private static native long getJ9ClassFromClass64(Class var0);

    private static native long getTotalInstanceSizeFromJ9Class64(long var0);

    private static native long getInstanceDescriptionFromJ9Class64(long var0);

    private static native long getDescriptionWordFromPtr64(long var0);

    public static int getNumSlotsInObject(Class clazz) {
        int n;
        if (ORBVMHelpers.is32Bit()) {
            int n2 = ORBVMHelpers.getJ9ClassFromClass32(clazz);
            int n3 = ORBVMHelpers.getTotalInstanceSizeFromJ9Class32(n2);
            n = n3 / 4;
        } else {
            long l = ORBVMHelpers.getJ9ClassFromClass64(clazz);
            long l2 = ORBVMHelpers.getTotalInstanceSizeFromJ9Class64(l);
            n = (int)l2 / 4;
            if (l2 > 0x1FFFFFFFL) {
                n = -1;
            }
        }
        return n;
    }

    public static int getSlotIndex(Field field) {
        int n = ORBVMHelpers.getNumBytesInJ9ObjectHeader();
        int n2 = 0;
        n2 = Modifier.isStatic(field.getModifiers()) ? (int)unsafe.staticFieldOffset(field) : (int)unsafe.objectFieldOffset(field);
        int n3 = (n2 - n) / 4;
        return n3;
    }

    public static void vmDeepCopy(Object object, Object object2, Class clazz, ClassLoader classLoader, int[] nArray, Class[] classArray, ORBBase oRBBase, Map map, Class clazz2) throws Exception {
        int n;
        int n2 = ORBVMHelpers.getNumBitsInDescriptionWord();
        int n3 = ORBVMHelpers.getNumBytesInJ9ObjectHeader();
        int n4 = ORBVMHelpers.getNumBytesInReferenceField();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (null == object || null == object2) {
            throw new NullPointerException();
        }
        if (ORBVMHelpers.is32Bit()) {
            n5 = ORBVMHelpers.getJ9ClassFromClass32(clazz);
            n6 = ORBVMHelpers.getTotalInstanceSizeFromJ9Class32(n5);
            n7 = ORBVMHelpers.getInstanceDescriptionFromJ9Class32(n5);
            n = n6 / n4;
        } else {
            l = ORBVMHelpers.getJ9ClassFromClass64(clazz);
            l2 = ORBVMHelpers.getTotalInstanceSizeFromJ9Class64(l);
            l3 = ORBVMHelpers.getInstanceDescriptionFromJ9Class64(l);
            n = (int)l2 / n4;
        }
        int n8 = 0;
        int n9 = 0;
        long l4 = 0L;
        int n10 = 0;
        if (ORBVMHelpers.isDescriptorPointerTagged(n7, l3)) {
            ++n10;
            if (ORBVMHelpers.is32Bit()) {
                n9 = n7 >> 1;
            } else {
                l4 = l3 >> 1;
            }
        } else if (ORBVMHelpers.is32Bit()) {
            n9 = ORBVMHelpers.getDescriptionWordFromPtr32(n7);
        } else {
            l4 = ORBVMHelpers.getDescriptionWordFromPtr64(l3);
        }
        int n11 = 0;
        while (n > 0) {
            int n12 = nArray[n11];
            int n13 = -1;
            if (ORBVMHelpers.getNumBytesInReferenceField() == 8 && n11 + 1 < nArray.length) {
                n13 = nArray[n11 + 1];
            }
            Class clazz3 = classArray[n11];
            if (n12 >= 0 || n13 >= 0) {
                if (ORBVMHelpers.isDescriptorPointerTagged(n9, l4)) {
                    Object object3 = unsafe.getObject(object, n3 + n8 * n4);
                    if (object3 != null) {
                        Object object4 = oRBBase.quickCopyIfPossible(object3, clazz3, classLoader, map, clazz2);
                        if (object4 != null) {
                            if (n12 >= 0) {
                                unsafe.putObject(object2, n3 + n12 * 4, object4);
                            }
                            if (++n8 >= n) break;
                            if (n10 == n2 - 1) {
                                if (ORBVMHelpers.is32Bit()) {
                                    n7 += ORBVMHelpers.getNumBytesInDescriptionWord();
                                } else {
                                    l3 += (long)ORBVMHelpers.getNumBytesInDescriptionWord();
                                }
                                n10 = 0;
                                if (ORBVMHelpers.is32Bit()) {
                                    n9 = ORBVMHelpers.getDescriptionWordFromPtr32(n7);
                                } else {
                                    l4 = ORBVMHelpers.getDescriptionWordFromPtr64(l3);
                                }
                            } else {
                                if (ORBVMHelpers.is32Bit()) {
                                    n9 >>= 1;
                                } else {
                                    l4 >>= 1;
                                }
                                ++n10;
                            }
                            if (ORBVMHelpers.getNumBytesInReferenceField() == 8) {
                                n11 += 2;
                                continue;
                            }
                            ++n11;
                            continue;
                        }
                        object3 = oRBBase.deepCopyIfRequired(object3, clazz3, classLoader, map, clazz3);
                        if (n12 >= 0) {
                            unsafe.putObject(object2, n3 + n12 * 4, object3);
                        }
                    }
                } else if (ORBVMHelpers.getNumBytesInReferenceField() != 8) {
                    unsafe.putInt(object2, n3 + n12 * n4, unsafe.getInt(object, n3 + n8 * n4));
                } else {
                    if (n12 >= 0) {
                        unsafe.putInt(object2, n3 + n12 * 4, unsafe.getInt(object, n3 + n8 * n4));
                    }
                    if (n13 >= 0) {
                        unsafe.putInt(object2, n3 + n13 * 4, unsafe.getInt(object, n3 + n8 * n4 + 4));
                    }
                }
            }
            if (++n8 >= n) break;
            if (n10 == n2 - 1) {
                if (ORBVMHelpers.is32Bit()) {
                    n7 += ORBVMHelpers.getNumBytesInDescriptionWord();
                } else {
                    l3 += (long)ORBVMHelpers.getNumBytesInDescriptionWord();
                }
                n10 = 0;
                if (ORBVMHelpers.is32Bit()) {
                    n9 = ORBVMHelpers.getDescriptionWordFromPtr32(n7);
                } else {
                    l4 = ORBVMHelpers.getDescriptionWordFromPtr64(l3);
                }
            } else {
                if (ORBVMHelpers.is32Bit()) {
                    n9 >>= 1;
                } else {
                    l4 >>= 1;
                }
                ++n10;
            }
            if (ORBVMHelpers.getNumBytesInReferenceField() == 8) {
                n11 += 2;
                continue;
            }
            ++n11;
        }
    }

    private static boolean isDescriptorPointerTagged(int n, long l) {
        return ORBVMHelpers.is32Bit() ? (n & 1) == 1 : (l & 1L) == 1L;
    }
}

