/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class JPEGBuffer {
    private boolean debug = false;
    final int BUFFER_SIZE = 4096;
    byte[] buf = new byte[4096];
    int bufAvail = 0;
    int bufPtr = 0;
    ImageInputStream iis;

    JPEGBuffer(ImageInputStream imageInputStream) {
        this.iis = imageInputStream;
    }

    void loadBuf(int n) throws IOException {
        if (this.debug) {
            System.out.print("loadbuf called with ");
            System.out.print("count " + n + ", ");
            System.out.println("bufAvail " + this.bufAvail + ", ");
        }
        if (n != 0 ? this.bufAvail >= n : this.bufAvail == 4096) {
            return;
        }
        if (this.bufAvail > 0 && this.bufAvail < 4096) {
            System.arraycopy((Object)this.buf, this.bufPtr, (Object)this.buf, 0, this.bufAvail);
        }
        int n2 = this.iis.read(this.buf, this.bufAvail, this.buf.length - this.bufAvail);
        if (this.debug) {
            System.out.println("iis.read returned " + n2);
        }
        if (n2 != -1) {
            this.bufAvail += n2;
        }
        this.bufPtr = 0;
        int n3 = Math.min(4096, n);
        if (this.bufAvail < n3) {
            throw new IIOException("Image Format Error");
        }
    }

    void readData(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (this.bufAvail >= n) {
            System.arraycopy((Object)this.buf, this.bufPtr, (Object)byArray, 0, n);
            this.bufAvail -= n;
            this.bufPtr += n;
            return;
        }
        int n2 = 0;
        if (this.bufAvail > 0) {
            System.arraycopy((Object)this.buf, this.bufPtr, (Object)byArray, 0, this.bufAvail);
            n2 = this.bufAvail;
            n -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.read(byArray, n2, n) != n) {
            throw new IIOException("Image format Error");
        }
    }

    void skipData(int n) throws IOException {
        if (this.bufAvail >= n) {
            this.bufAvail -= n;
            this.bufPtr += n;
            return;
        }
        if (this.bufAvail > 0) {
            n -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.skipBytes(n) != n) {
            throw new IIOException("Image format Error");
        }
    }

    void pushBack() throws IOException {
        this.iis.seek(this.iis.getStreamPosition() - (long)this.bufAvail);
        this.bufAvail = 0;
        this.bufPtr = 0;
    }

    long getStreamPosition() throws IOException {
        return this.iis.getStreamPosition() - (long)this.bufAvail;
    }

    boolean scanForFF(JPEGImageReader jPEGImageReader) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            while (this.bufAvail > 0) {
                if ((this.buf[this.bufPtr++] & 0xFF) == 255) {
                    --this.bufAvail;
                    bl2 = true;
                    break;
                }
                --this.bufAvail;
            }
            this.loadBuf(0);
            if (bl2) {
                while (this.bufAvail > 0 && (this.buf[this.bufPtr] & 0xFF) == 255) {
                    ++this.bufPtr;
                    --this.bufAvail;
                }
            }
            if (this.bufAvail != 0) continue;
            bl = true;
            this.buf[0] = -39;
            this.bufAvail = 1;
            this.bufPtr = 0;
            bl2 = true;
        }
        return bl;
    }

    void print(int n) {
        System.out.print("buffer has ");
        System.out.print(this.bufAvail);
        System.out.println(" bytes available");
        if (this.bufAvail < n) {
            n = this.bufAvail;
        }
        int n2 = this.bufPtr;
        while (n > 0) {
            int n3 = this.buf[n2++] & 0xFF;
            System.out.print(" " + Integer.toHexString(n3));
            --n;
        }
        System.out.println();
    }
}

