/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.Method;

abstract class IndirectHandle
extends PrimitiveHandle {
    IndirectHandle(MethodType methodType, Class<?> clazz, String string, byte by, int n) {
        super(methodType, clazz, string, by, n, null);
    }

    IndirectHandle(MethodType methodType, Class<?> clazz, String string, byte by) {
        super(methodType, clazz, string, by, null);
    }

    IndirectHandle(IndirectHandle indirectHandle, MethodType methodType) {
        super(indirectHandle, methodType);
    }

    protected abstract long vtableOffset(Object var1);

    protected final long vtableIndexArgument(Object object) {
        return -this.vtableOffset(object);
    }

    protected final long jittedMethodAddress(Object object) {
        long l = IndirectHandle.getJ9ClassFromClass(object.getClass());
        long l2 = VTABLE_ENTRY_SIZE == 4 ? (long)UNSAFE.getInt(l - this.vtableOffset(object)) : UNSAFE.getLong(l - this.vtableOffset(object));
        return l2;
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    protected static final MethodType indirectMethodType(Method method) {
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return IndirectHandle.indirectMethodType(methodType, method.getDeclaringClass());
    }

    protected static final MethodType indirectMethodType(MethodType methodType, Class<?> clazz) {
        return methodType.insertParameterTypes(0, clazz);
    }

    @Override
    public MethodHandle bindTo(Object object) throws IllegalArgumentException, ClassCastException {
        if (null == object) {
            return super.bindTo(object);
        }
        Class<?> clazz = this.type().parameterType(0);
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        object = clazz.cast(object);
        try {
            MethodHandle methodHandle = MethodHandles.Lookup.internalPrivilegedLookup.bind(object, this.name, this.type().dropFirstParameterType());
            if (this instanceof InterfaceHandle && (methodHandle.getModifiers() & 1) == 0) {
                throw new IllegalAccessException();
            }
            return methodHandle;
        }
        catch (IllegalAccessException illegalAccessException) {
            return MethodHandles.insertArguments(this, 0, object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error(noSuchMethodException);
        }
    }

    final void compareWithIndirect(IndirectHandle indirectHandle, Comparator comparator) {
        comparator.compareStructuralParameter(indirectHandle.referenceClass, this.referenceClass);
        comparator.compareStructuralParameter(indirectHandle.vmSlot, this.vmSlot);
    }
}

