/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VMLangAccess;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.IOUtils;
import sun.misc.Unsafe;

final class SecurityFrameInjector {
    static Map<ClassLoader, WeakReference<Class<?>>> LoaderToSecurityFrameClassMap = Collections.synchronizedMap(new WeakHashMap());
    static byte[] securityFrameClassBytes = null;
    static SecurityFrameInjectorLoaderLock loaderLock = new SecurityFrameInjectorLoaderLock();
    private static final int CALLER_SENSITIVE_BIT = 0x100000;

    SecurityFrameInjector() {
    }

    static boolean virtualCallAllowed(MethodHandle methodHandle, Class<?> clazz) {
        if (methodHandle instanceof PrimitiveHandle) {
            Class<?> clazz2 = methodHandle.getDefc();
            if (clazz2 == clazz) {
                return true;
            }
            int n = methodHandle.getModifiers();
            if (Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                return false;
            }
            if (clazz.isAssignableFrom(clazz2) || clazz2.isInterface()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] initializeSecurityFrameClassBytes() {
        if (securityFrameClassBytes != null) return securityFrameClassBytes;
        Class<SecurityFrameInjector> clazz = SecurityFrameInjector.class;
        synchronized (SecurityFrameInjector.class) {
            if (securityFrameClassBytes != null) return securityFrameClassBytes;
            securityFrameClassBytes = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        InputStream inputStream = MethodHandles.Lookup.class.getResourceAsStream("/java/lang/invoke/SecurityFrame.class");
                        return IOUtils.readFully(inputStream, Integer.MAX_VALUE, false);
                    }
                    catch (IOException iOException) {
                        throw new Error(Msg.getString("K056A"), iOException);
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return securityFrameClassBytes;
        }
    }

    static Class<?> probeLoaderToSecurityFrameMap(ClassLoader classLoader) {
        WeakReference<Class<?>> weakReference = LoaderToSecurityFrameClassMap.get(classLoader);
        if (weakReference != null) {
            return (Class)weakReference.get();
        }
        return null;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrame(MethodHandle methodHandle, final Class<?> clazz) {
        SecurityFrameInjector.initializeSecurityFrameClassBytes();
        boolean bl = methodHandle.isVarargsCollector();
        if (methodHandle instanceof PrimitiveHandle) {
            bl |= MethodHandles.Lookup.isVarargs(methodHandle.getModifiers());
        }
        final MethodHandle methodHandle2 = methodHandle;
        MethodType methodType = methodHandle.type;
        try {
            Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                private Class<?> injectSecurityFrameIntoLoader(ClassLoader classLoader, ProtectionDomain protectionDomain) {
                    return Unsafe.getUnsafe().defineClass("java.lang.invoke.SecurityFrame", securityFrameClassBytes, 0, securityFrameClassBytes.length, classLoader, protectionDomain);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    Object object;
                    VMLangAccess vMLangAccess = MethodHandles.Lookup.getVMLangAccess();
                    ClassLoader classLoader = vMLangAccess.getClassloader(clazz);
                    Class<?> clazz2 = SecurityFrameInjector.probeLoaderToSecurityFrameMap(classLoader);
                    if (clazz2 == null) {
                        object = loaderLock;
                        synchronized (object) {
                            clazz2 = SecurityFrameInjector.probeLoaderToSecurityFrameMap(classLoader);
                            if (clazz2 == null) {
                                clazz2 = this.injectSecurityFrameIntoLoader(classLoader, clazz.getProtectionDomain());
                                LoaderToSecurityFrameClassMap.put(classLoader, new WeakReference(clazz2));
                            }
                        }
                    }
                    try {
                        object = clazz2.getConstructor(MethodHandle.class, Class.class);
                        ((AccessibleObject)object).setAccessible(true);
                        return ((Constructor)object).newInstance(methodHandle2, clazz);
                    }
                    catch (ReflectiveOperationException | SecurityException exception) {
                        throw new Error(exception);
                    }
                }
            });
            methodHandle = MethodHandles.Lookup.internalPrivilegedLookup.bind(object, "invoke", MethodType.methodType(Object.class, Object[].class));
            methodHandle = methodHandle.asType(methodType);
            if (bl) {
                methodHandle = methodHandle.asVarargsCollector(methodType.lastParameterType());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
        return methodHandle;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrameIfRequired(MethodHandles.Lookup lookup, MethodHandle methodHandle) throws IllegalAccessException {
        if (SecurityFrameInjector.isCallerSensitive(methodHandle)) {
            if (lookup.isWeakenedLookup()) {
                throw new IllegalAccessException(Msg.getString("K0589"));
            }
            methodHandle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrame(methodHandle, lookup.accessClass);
        }
        return methodHandle;
    }

    static boolean isCallerSensitive(MethodHandle methodHandle) {
        return 0x100000 == (methodHandle.getModifiers() & 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle penetrateSecurityFrame(MethodHandle methodHandle, MethodHandles.Lookup lookup) {
        MethodType methodType = methodHandle.type;
        boolean bl = false;
        if (methodHandle.kind == 17) {
            bl = true;
            methodHandle = ((VarargsCollectorHandle)methodHandle).next;
        }
        if (methodHandle.kind == 13) {
            methodHandle = ((AsTypeHandle)methodHandle).next;
        }
        if (methodHandle.kind == 15) {
            methodHandle = ((FilterReturnHandle)methodHandle).next;
        }
        if (methodHandle.kind == 10) {
            methodHandle = ((CollectHandle)methodHandle).next;
        }
        if (methodHandle.kind == 13) {
            methodHandle = ((AsTypeHandle)methodHandle).next;
        }
        if (methodHandle.kind == 15) {
            methodHandle = ((FilterReturnHandle)methodHandle).next;
        }
        if (methodHandle.kind == 0) {
            ReceiverBoundHandle receiverBoundHandle = (ReceiverBoundHandle)methodHandle;
            Object object = receiverBoundHandle.receiver;
            VMLangAccess vMLangAccess = MethodHandles.Lookup.getVMLangAccess();
            ClassLoader classLoader = vMLangAccess.getClassloader(object.getClass());
            Class<?> clazz = null;
            Object object2 = loaderLock;
            synchronized (object2) {
                clazz = SecurityFrameInjector.probeLoaderToSecurityFrameMap(classLoader);
            }
            if (clazz == null || !clazz.isInstance(object)) {
                return null;
            }
            object2 = clazz;
            MethodHandle methodHandle2 = AccessController.doPrivileged(new PrivilegedAction<MethodHandle>((Class)object2, object){
                final /* synthetic */ Class val$finalInjectedSecurityFrame;
                final /* synthetic */ Object val$receiver;
                {
                    this.val$finalInjectedSecurityFrame = clazz;
                    this.val$receiver = object;
                }

                @Override
                public MethodHandle run() {
                    try {
                        Field field = this.val$finalInjectedSecurityFrame.getDeclaredField("target");
                        field.setAccessible(true);
                        return (MethodHandle)field.get(this.val$receiver);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                        throw (InternalError)new InternalError().initCause(exception);
                    }
                }
            });
            Class clazz2 = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>((Class)object2, object){
                final /* synthetic */ Class val$finalInjectedSecurityFrame;
                final /* synthetic */ Object val$receiver;
                {
                    this.val$finalInjectedSecurityFrame = clazz;
                    this.val$receiver = object;
                }

                @Override
                public Class<?> run() {
                    try {
                        Field field = this.val$finalInjectedSecurityFrame.getDeclaredField("accessClass");
                        field.setAccessible(true);
                        return (Class)field.get(this.val$receiver);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                        throw (InternalError)new InternalError().initCause(exception);
                    }
                }
            });
            if (lookup.accessMode != 64 && clazz2 != lookup.accessClass) {
                return null;
            }
            if (methodHandle2.type == methodType && methodHandle2 instanceof PrimitiveHandle && MethodHandles.Lookup.isVarargs(methodHandle2.getModifiers()) == bl) {
                return methodHandle2;
            }
        }
        return null;
    }

    static final class SecurityFrameInjectorLoaderLock {
        SecurityFrameInjectorLoaderLock() {
        }
    }
}

