/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class StructureTypeManager {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_VOID = 0;
    public static final int TYPE_U8 = 1;
    public static final int TYPE_U16 = 2;
    public static final int TYPE_U32 = 3;
    public static final int TYPE_U64 = 4;
    public static final int TYPE_UDATA = 5;
    public static final int TYPE_I8 = 6;
    public static final int TYPE_I16 = 7;
    public static final int TYPE_I32 = 8;
    public static final int TYPE_I64 = 9;
    public static final int TYPE_IDATA = 10;
    public static final int TYPE_SIMPLE_MIN = 1;
    public static final int TYPE_SIMPLE_MAX = 99;
    public static final int TYPE_BOOL = 100;
    public static final int TYPE_ENUM = 101;
    public static final int TYPE_DOUBLE = 102;
    public static final int TYPE_FLOAT = 103;
    public static final int TYPE_BITFIELD = 104;
    public static final int TYPE_ENUM_POINTER = 105;
    public static final int TYPE_POINTER = 110;
    public static final int TYPE_J9SRP = 111;
    public static final int TYPE_J9WSRP = 112;
    public static final int TYPE_ARRAY = 113;
    public static final int TYPE_J9SRP_POINTER = 114;
    public static final int TYPE_J9WSRP_POINTER = 115;
    public static final int TYPE_STRUCTURE = 120;
    public static final int TYPE_STRUCTURE_POINTER = 121;
    public static final int TYPE_FJ9OBJECT = 130;
    public static final int TYPE_FJ9OBJECT_POINTER = 131;
    public static final int TYPE_J9OBJECTCLASS = 132;
    public static final int TYPE_J9OBJECTCLASS_POINTER = 133;
    public static final int TYPE_J9OBJECTMONITOR = 134;
    public static final int TYPE_J9OBJECTMONITOR_POINTER = 135;
    public static final Map<String, Integer> simpleTypeCodeMap;
    public static final Map<Integer, String> simpleTypeAccessorMap;
    private final Set<String> structureNames = new HashSet<String>();
    private final Set<String> enumNames = new HashSet<String>();
    private static final Pattern CVQualifierPattern;

    public StructureTypeManager(Collection<StructureReader.StructureDescriptor> collection) {
        for (StructureReader.StructureDescriptor structureDescriptor : collection) {
            if (structureDescriptor.getFields().size() == 0 && structureDescriptor.getConstants().size() > 0) {
                this.enumNames.add(structureDescriptor.getName());
                continue;
            }
            this.structureNames.add(structureDescriptor.getName());
        }
    }

    public int getType(String string) {
        String string2 = CVQualifierPattern.matcher(string).replaceAll("");
        if (simpleTypeCodeMap.containsKey(string2)) {
            return simpleTypeCodeMap.get(string2);
        }
        CTypeParser cTypeParser = new CTypeParser(string2);
        if (cTypeParser.getSuffix().endsWith("]")) {
            return 113;
        }
        if (cTypeParser.getSuffix().contains(":")) {
            return 104;
        }
        if (string2.endsWith("*")) {
            int n = this.getType(string2.substring(0, string2.length() - 1).trim());
            switch (n) {
                case -1: {
                    return -1;
                }
                case 120: {
                    return 121;
                }
                case 130: {
                    return 131;
                }
                case 132: {
                    return 133;
                }
                case 134: {
                    return 135;
                }
                case 111: {
                    return 114;
                }
                case 112: {
                    return 115;
                }
                case 101: {
                    return 105;
                }
            }
            return 110;
        }
        if (string2.equals("J9SRP") || string2.startsWith("J9SRP(")) {
            return 111;
        }
        if (string2.equals("J9WSRP") || string2.startsWith("J9WSRP(")) {
            return 112;
        }
        if (string2.startsWith("struct ") || string2.startsWith("class ") || this.structureNames.contains(string2.trim())) {
            return 120;
        }
        if (string2.startsWith("enum ") || this.enumNames.contains(string2.trim())) {
            return 101;
        }
        return -1;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("void", 0);
        hashMap.put("U8", 1);
        hashMap.put("U16", 2);
        hashMap.put("U32", 3);
        hashMap.put("U64", 4);
        hashMap.put("UDATA", 5);
        hashMap.put("I8", 6);
        hashMap.put("I16", 7);
        hashMap.put("I32", 8);
        hashMap.put("I64", 9);
        hashMap.put("IDATA", 10);
        hashMap.put("char", 1);
        hashMap.put("bool", 100);
        hashMap.put("double", 102);
        hashMap.put("float", 103);
        hashMap.put("fj9object_t", 130);
        hashMap.put("iconv_t", 10);
        hashMap.put("j9objectclass_t", 132);
        hashMap.put("j9objectmonitor_t", 134);
        simpleTypeCodeMap = Collections.unmodifiableMap(hashMap);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        hashMap2.put(1, "getByteAtOffset");
        hashMap2.put(2, "getShortAtOffset");
        hashMap2.put(3, "getIntAtOffset");
        hashMap2.put(4, "getLongAtOffset");
        hashMap2.put(5, "getUDATAAtOffset");
        hashMap2.put(6, "getByteAtOffset");
        hashMap2.put(7, "getShortAtOffset");
        hashMap2.put(8, "getIntAtOffset");
        hashMap2.put(9, "getLongAtOffset");
        hashMap2.put(10, "getIDATAAtOffset");
        simpleTypeAccessorMap = Collections.unmodifiableMap(hashMap2);
        CVQualifierPattern = Pattern.compile("\\s*\\b(const|volatile)\\b\\s*");
    }
}

