/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFMemorySource;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import java.util.Properties;

public class ProgramHeaderEntry {
    private static final int PT_LOAD = 1;
    private static final int PT_DYNAMIC = 2;
    private static final int PT_NOTE = 4;
    private static final int PT_GNU_EH_FRAME = 1685382480;
    private static final int PF_X = 1;
    private static final int PF_W = 2;
    private static final int PF_R = 4;
    private int _type;
    public final long fileOffset;
    public final long fileSize;
    public final long virtualAddress;
    public final long physicalAddress;
    public final long memorySize;
    private int _flags;
    private final ELFFileReader reader;

    ProgramHeaderEntry(int n, long l, long l2, long l3, long l4, long l5, int n2, long l6, ELFFileReader eLFFileReader) {
        this._type = n;
        this.fileOffset = l;
        this.fileSize = l2;
        this.virtualAddress = l3;
        this.physicalAddress = l4;
        this.memorySize = l5;
        this._flags = n2;
        this.reader = eLFFileReader;
    }

    boolean isEmpty() {
        return 0L == this.fileSize;
    }

    boolean isDynamic() {
        return 2 == this._type;
    }

    boolean isLoadable() {
        return 1 == this._type;
    }

    boolean isNote() {
        return 4 == this._type;
    }

    public boolean isEhFrame() {
        return 1685382480 == this._type;
    }

    IMemorySource asMemorySource() {
        ProtectedMemoryRange protectedMemoryRange = null;
        if (!this.isEmpty()) {
            boolean bl = (this._flags & 1) != 0;
            protectedMemoryRange = new ELFMemorySource(this.virtualAddress, this.memorySize, this.fileOffset, this.reader);
        } else {
            protectedMemoryRange = new UnbackedMemorySource(this.virtualAddress, this.memorySize, "ELF ProgramHeaderEntry storage declared but data not included");
        }
        Properties properties = ((IDetailedMemoryRange)((Object)protectedMemoryRange)).getProperties();
        properties.setProperty("IN_CORE", "" + !this.isEmpty());
        if ((this._flags & 2) != 0) {
            properties.setProperty("writable", Boolean.TRUE.toString());
        }
        if ((this._flags & 1) != 0) {
            properties.setProperty("executable", Boolean.TRUE.toString());
        }
        if ((this._flags & 4) != 0) {
            properties.setProperty("readable", Boolean.TRUE.toString());
        }
        return protectedMemoryRange;
    }

    boolean validInProcess(long l) {
        return this.virtualAddress <= l && l < this.virtualAddress + this.memorySize;
    }

    boolean contains(long l) {
        return false == this.isEmpty() && this.validInProcess(l);
    }
}

