/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCClassStaticsIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCConstantPoolObjectSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCClassIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_statics = 1;
    public static final int state_constant_pool = 2;
    public static final int state_slots = 3;
    public static final int state_end = 4;
    protected int state = 0;
    protected GCClassStaticsIterator staticsIterator;
    protected GCConstantPoolObjectSlotIterator constantPoolSlotIterator;
    protected J9ClassPointer clazz;

    protected GCClassIterator(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        this.staticsIterator = GCClassStaticsIterator.fromJ9Class(j9ClassPointer);
        this.constantPoolSlotIterator = GCConstantPoolObjectSlotIterator.fromJ9Class(j9ClassPointer);
        this.clazz = j9ClassPointer;
    }

    public static GCClassIterator fromJ9Class(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new GCClassIterator(j9ClassPointer);
    }

    @Override
    public boolean hasNext() {
        if (this.state == 4) {
            return false;
        }
        switch (this.state) {
            case 0: {
                ++this.state;
            }
            case 1: {
                if (this.staticsIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 2: {
                if (this.constantPoolSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 3: {
                if (this.clazz != null) {
                    return true;
                }
                ++this.state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.staticsIterator.next();
                }
                case 2: {
                    return this.constantPoolSlotIterator.next();
                }
                case 3: {
                    if (this.clazz == null) break;
                    J9ObjectPointer j9ObjectPointer = null;
                    try {
                        j9ObjectPointer = this.clazz.classObject();
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error fetching the class object", corruptDataException, false);
                    }
                    this.clazz = null;
                    return j9ObjectPointer;
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.staticsIterator.nextAddress();
                }
                case 2: {
                    return this.constantPoolSlotIterator.nextAddress();
                }
                case 3: {
                    if (this.clazz == null) break;
                    VoidPointer voidPointer = null;
                    try {
                        voidPointer = VoidPointer.cast(this.clazz.classObjectEA());
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error fetching the class object", corruptDataException, false);
                    }
                    this.clazz = null;
                    return voidPointer;
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public int getState() {
        return this.state;
    }
}

