/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I16Pointer
extends Pointer {
    public static final int SIZEOF = 2;
    public static final I16Pointer NULL = new I16Pointer(0L);

    protected I16Pointer(long l) {
        super(l);
    }

    public static I16Pointer cast(AbstractPointer abstractPointer) {
        return I16Pointer.cast(abstractPointer.getAddress());
    }

    public static I16Pointer cast(UDATA uDATA) {
        return I16Pointer.cast(uDATA.longValue());
    }

    public static I16Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new I16Pointer(l);
    }

    @Override
    public I16 at(long l) throws CorruptDataException {
        return new I16(this.getShortAtOffset(l * 2L));
    }

    @Override
    public I16 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public I16Pointer untag() {
        return this.untag(1L);
    }

    @Override
    public I16Pointer untag(long l) {
        return new I16Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public I16Pointer add(long l) {
        return new I16Pointer(this.address + 2L * l);
    }

    @Override
    public I16Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public I16Pointer addOffset(long l) {
        return new I16Pointer(this.address + l);
    }

    @Override
    public I16Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public I16Pointer sub(long l) {
        return new I16Pointer(this.address - 2L * l);
    }

    @Override
    public I16Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public I16Pointer subOffset(long l) {
        return new I16Pointer(this.address - l);
    }

    @Override
    public I16Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 2L;
    }
}

