/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.structure.J9ROMMethod;

public class J9MethodHelper {
    public static J9ROMMethodPointer romMethod(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        return J9ROMMethodPointer.cast(j9MethodPointer.bytecodes().addOffset(-J9ROMMethod.SIZEOF));
    }

    public static J9MethodPointer nextMethod(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        return J9MethodPointer.cast(j9MethodPointer.addOffset(J9Method.SIZEOF));
    }

    public static String getName(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        if (j9MethodPointer.isNull()) {
            return "bad ramMethod";
        }
        J9ConstantPoolPointer j9ConstantPoolPointer = ConstantPoolHelpers.J9_CP_FROM_METHOD(j9MethodPointer);
        if (j9ConstantPoolPointer.isNull()) {
            return "error reading constant pool from ramMethod";
        }
        J9ClassPointer j9ClassPointer = ConstantPoolHelpers.J9_CLASS_FROM_CP(j9ConstantPoolPointer);
        if (j9ClassPointer.isNull()) {
            return "error reading class name from constant pool";
        }
        J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer).nameAndSignature();
        String string = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name());
        String string2 = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature());
        return J9ClassHelper.getName(j9ClassPointer) + "." + string + string2;
    }
}

