/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.PackageHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class ModularityHelper {
    public static boolean moduleFilterMatchAll(J9ModulePointer j9ModulePointer, String string) {
        return true;
    }

    public static void printJ9Module(J9ModulePointer j9ModulePointer, PrintStream printStream) throws CorruptDataException {
        String string = J9ObjectHelper.stringValue(j9ModulePointer.moduleName());
        String string2 = j9ModulePointer.getHexAddress();
        printStream.printf("%-30s !j9module %s%n", string, string2);
    }

    public static void printPackageJ9Module(J9PackagePointer j9PackagePointer, PrintStream printStream) throws CorruptDataException {
        J9ModulePointer j9ModulePointer = j9PackagePointer.module();
        ModularityHelper.printJ9Module(j9ModulePointer, printStream);
    }

    public static void printJ9Package(J9PackagePointer j9PackagePointer, PrintStream printStream) throws CorruptDataException {
        String string = J9UTF8Helper.stringValue(j9PackagePointer.packageName());
        String string2 = j9PackagePointer.getHexAddress();
        printStream.printf("%-45s !j9package %s%n", string, string2);
    }

    public static void printJ9Class(J9ClassPointer j9ClassPointer, PrintStream printStream) throws CorruptDataException {
        String string = J9ClassHelper.getName(j9ClassPointer);
        String string2 = j9ClassPointer.getHexAddress();
        printStream.printf("%-30s !j9class %s%n", string, string2);
    }

    public static void printPackageExportVerbose(J9PackagePointer j9PackagePointer, PrintStream printStream) throws CorruptDataException {
        printStream.print("Exports ");
        ModularityHelper.printJ9Package(j9PackagePointer, printStream);
        if (j9PackagePointer.exportToAll().isZero()) {
            ModularityHelper.printPackageExportTo(j9PackagePointer, printStream, "     to ");
        }
    }

    public static void printPackageExports(J9PackagePointer j9PackagePointer, PrintStream printStream) throws CorruptDataException {
        if (j9PackagePointer.exportToAll().isZero()) {
            int n = ModularityHelper.printPackageExportTo(j9PackagePointer, printStream, "");
            if (0 == n) {
                printStream.println("Package is not exported");
            }
        } else {
            printStream.println("Package is exported to all");
        }
    }

    private static int printPackageExportTo(J9PackagePointer j9PackagePointer, PrintStream printStream, String string) throws CorruptDataException {
        int n = 0;
        J9HashTablePointer j9HashTablePointer = j9PackagePointer.exportsHashTable();
        HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
        Iterator iterator = hashTable.iterator();
        while (iterator.hasNext()) {
            ++n;
            J9ModulePointer j9ModulePointer = (J9ModulePointer)iterator.next();
            printStream.print(string);
            ModularityHelper.printJ9Module(j9ModulePointer, printStream);
        }
        if (!j9PackagePointer.exportToAllUnnamed().isZero()) {
            ++n;
            printStream.printf("%sALL-UNNAMED%n", string);
        }
        return n;
    }

    public static int iterateModules(PrintStream printStream, ModuleIteratorFilter moduleIteratorFilter, ModuleOutput moduleOutput, String string) throws CorruptDataException {
        int n = 0;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
            GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
            while (gCClassLoaderIterator.hasNext()) {
                J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9ClassLoaderPointer.moduleHashTable());
                Iterator iterator = hashTable.iterator();
                while (iterator.hasNext()) {
                    J9ModulePointer j9ModulePointer = (J9ModulePointer)iterator.next();
                    if (!moduleIteratorFilter.filter(j9ModulePointer, string)) continue;
                    ++n;
                    moduleOutput.print(j9ModulePointer, printStream);
                }
            }
        }
        return n;
    }

    public static int iteratePackages(PrintStream printStream, PackageIteratorFilter packageIteratorFilter, PackageOutput packageOutput, String string) throws CorruptDataException {
        int n = 0;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
            GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
            while (gCClassLoaderIterator.hasNext()) {
                n += ModularityHelper.iterateClassLoaderPackages(printStream, packageIteratorFilter, packageOutput, string, gCClassLoaderIterator.next());
            }
        }
        return n;
    }

    public static int iterateClassLoaderPackages(PrintStream printStream, PackageIteratorFilter packageIteratorFilter, PackageOutput packageOutput, String string, J9ClassLoaderPointer j9ClassLoaderPointer) throws CorruptDataException {
        int n = 0;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
            HashTable<J9PackagePointer> hashTable = PackageHashTable.fromJ9HashTable(j9ClassLoaderPointer.packageHashTable());
            Iterator iterator = hashTable.iterator();
            while (iterator.hasNext()) {
                J9PackagePointer j9PackagePointer = (J9PackagePointer)iterator.next();
                if (!packageIteratorFilter.filter(j9PackagePointer, string)) continue;
                ++n;
                packageOutput.print(j9PackagePointer, printStream);
            }
        }
        return n;
    }

    public static int iterateClassLoaderClasses(PrintStream printStream, ClassIteratorFilter classIteratorFilter, ClassOutput classOutput, String string, J9ClassLoaderPointer j9ClassLoaderPointer) throws CorruptDataException {
        int n = 0;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
            Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(j9ClassLoaderPointer);
            while (iterator.hasNext()) {
                J9ClassPointer j9ClassPointer = iterator.next();
                if (!classIteratorFilter.filter(j9ClassPointer, string)) continue;
                ++n;
                classOutput.print(j9ClassPointer, printStream);
            }
        }
        return n;
    }

    @FunctionalInterface
    public static interface PackageOutput {
        public void print(J9PackagePointer var1, PrintStream var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface PackageIteratorFilter {
        public boolean filter(J9PackagePointer var1, String var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ModuleOutput {
        public void print(J9ModulePointer var1, PrintStream var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ModuleIteratorFilter {
        public boolean filter(J9ModulePointer var1, String var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ClassOutput {
        public void print(J9ClassPointer var1, PrintStream var2) throws CorruptDataException;
    }

    @FunctionalInterface
    public static interface ClassIteratorFilter {
        public boolean filter(J9ClassPointer var1, String var2) throws CorruptDataException;
    }
}

