/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.LiveSetWalker;
import com.ibm.j9ddr.vm29.j9.RootSet;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_AllocationContextPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ACCommand
extends Command {
    private GCHeapRegionManager heapRegionManager;

    public ACCommand() {
        this.addCommand("ac", "<address> [ xrefs | ownedRegions ]", "Dump allocation context details");
        this.addCommand("acforobject", "<address>", "Find allocation context which owns the specified object");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (string.equalsIgnoreCase("!acforobject")) {
                if (null == this.heapRegionManager) {
                    MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = MM_GCExtensionsPointer.cast(j9JavaVMPointer.gcExtensions()).heapRegionManager();
                    this.heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(mM_HeapRegionManagerPointer);
                }
                if (stringArray.length < 1) {
                    throw new DDRInteractiveCommandException("Invalid number of arguments specified.");
                }
                long l = Long.decode(stringArray[0]);
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
                this.dumpACForObject(j9JavaVMPointer, j9ObjectPointer, printStream);
            } else {
                MM_GCExtensionsPointer mM_GCExtensionsPointer = MM_GCExtensionsPointer.cast(j9JavaVMPointer.gcExtensions());
                if (stringArray.length < 1) {
                    throw new DDRInteractiveCommandException("Invalid number of arguments specified.");
                }
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 1; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2.equalsIgnoreCase("xrefs")) {
                        bl = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ownedRegions")) {
                        bl2 = true;
                        continue;
                    }
                    throw new DDRInteractiveCommandException("Unrecognized acforobject subcommand -->" + string2);
                }
                long l = Long.decode(stringArray[0]);
                MM_AllocationContextPointer mM_AllocationContextPointer = MM_AllocationContextPointer.cast(l);
                if (bl) {
                    if (GCExtensions.isVLHGC()) {
                        context.execute("!mm_allocationcontexttarok", new String[]{stringArray[0]}, printStream);
                    }
                    this.dumpLiveReferences(j9JavaVMPointer, mM_AllocationContextPointer, printStream);
                }
                if (bl2) {
                    this.dumpOwnedRegions(j9JavaVMPointer, mM_AllocationContextPointer, printStream);
                }
            }
        }
        catch (DDRInteractiveCommandException dDRInteractiveCommandException) {
            throw dDRInteractiveCommandException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printStream);
            throw new DDRInteractiveCommandException(throwable);
        }
    }

    private void dumpOwnedRegions(J9JavaVMPointer j9JavaVMPointer, MM_AllocationContextPointer mM_AllocationContextPointer, PrintStream printStream) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            Table table = new Table("Regions Owned by AC " + mM_AllocationContextPointer.getHexAddress());
            table.row("Region", "containsObjects");
            GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
            while (gCHeapRegionIterator.hasNext()) {
                GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
                MM_HeapRegionDescriptorVLHGCPointer mM_HeapRegionDescriptorVLHGCPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(gCHeapRegionDescriptor.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer = mM_HeapRegionDescriptorVLHGCPointer._allocateData()._owningContext();
                if (!mM_AllocationContextTarokPointer.eq(mM_AllocationContextPointer)) continue;
                table.row("!mm_heapregiondescriptorvlhgc " + mM_HeapRegionDescriptorVLHGCPointer.getHexAddress(), Boolean.toString(gCHeapRegionDescriptor.containsObjects()));
            }
            table.render(printStream);
        }
    }

    private void dumpLiveReferences(J9JavaVMPointer j9JavaVMPointer, MM_AllocationContextPointer mM_AllocationContextPointer, PrintStream printStream) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer = MM_AllocationContextTarokPointer.cast(mM_AllocationContextPointer);
            MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = MM_GCExtensionsPointer.cast(j9JavaVMPointer.gcExtensions()).heapRegionManager();
            GCHeapRegionManager gCHeapRegionManager = GCHeapRegionManager.fromHeapRegionManager(mM_HeapRegionManagerPointer);
            Table table = new Table("Live References into AC " + mM_AllocationContextPointer.getHexAddress());
            table.row("Object", "Field");
            printStream.println("Walking live set in search of external references into ac: " + mM_AllocationContextPointer.getHexAddress());
            long l = System.currentTimeMillis();
            LiveReferenceVisitor liveReferenceVisitor = new LiveReferenceVisitor(gCHeapRegionManager, mM_AllocationContextTarokPointer, table);
            LiveSetWalker.walkLiveSet(liveReferenceVisitor, RootSet.RootSetType.ALL);
            l = System.currentTimeMillis() - l;
            table.render(printStream);
            printStream.println("\nFinished live reference walk in " + l + "ms");
            printStream.println("Found " + liveReferenceVisitor.getNumExternalReferencesFound() + " external references.");
        }
    }

    public void dumpACForObject(J9JavaVMPointer j9JavaVMPointer, StructurePointer structurePointer, PrintStream printStream) throws CorruptDataException {
        GCHeapRegionDescriptor gCHeapRegionDescriptor;
        if (GCExtensions.isVLHGC() && null != structurePointer && !structurePointer.isNull() && null != (gCHeapRegionDescriptor = this.heapRegionManager.regionDescriptorForAddress(structurePointer))) {
            MM_HeapRegionDescriptorVLHGCPointer mM_HeapRegionDescriptorVLHGCPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(gCHeapRegionDescriptor.getHeapRegionDescriptorPointer());
            StructurePointer structurePointer2 = mM_HeapRegionDescriptorVLHGCPointer._allocateData()._owningContext().getAsRuntimeType();
            printStream.println("Object's owning context: " + structurePointer2.formatShortInteractive());
        }
    }

    static class LiveReferenceVisitor
    implements LiveSetWalker.ObjectVisitor {
        GCHeapRegionManager heapRegionManager;
        MM_AllocationContextTarokPointer allocationContext;
        Table table;
        int numExternalReferences = 0;

        public LiveReferenceVisitor(GCHeapRegionManager gCHeapRegionManager, MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer, Table table) {
            this.heapRegionManager = gCHeapRegionManager;
            this.allocationContext = mM_AllocationContextTarokPointer;
            this.table = table;
        }

        @Override
        public boolean visit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            try {
                GCHeapRegionDescriptor gCHeapRegionDescriptor = this.heapRegionManager.regionDescriptorForAddress(j9ObjectPointer);
                MM_HeapRegionDescriptorVLHGCPointer mM_HeapRegionDescriptorVLHGCPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(gCHeapRegionDescriptor.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer = mM_HeapRegionDescriptorVLHGCPointer._allocateData()._owningContext();
                if (!mM_AllocationContextTarokPointer.eq(this.allocationContext)) {
                    StructurePointer structurePointer;
                    GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, false);
                    while (gCObjectIterator.hasNext()) {
                        structurePointer = gCObjectIterator.next();
                        if (!structurePointer.notNull()) continue;
                        this.checkField(j9ObjectPointer, (J9ObjectPointer)structurePointer);
                    }
                    if (J9ObjectHelper.getClassName(j9ObjectPointer).equals("java/lang/Class")) {
                        Object object;
                        structurePointer = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(j9ObjectPointer);
                        GCClassIterator gCClassIterator = GCClassIterator.fromJ9Class((J9ClassPointer)structurePointer);
                        while (gCClassIterator.hasNext()) {
                            object = gCClassIterator.next();
                            if (!((AbstractPointer)object).notNull()) continue;
                            this.checkField(j9ObjectPointer, (J9ObjectPointer)object);
                        }
                        object = GCClassIteratorClassSlots.fromJ9Class((J9ClassPointer)structurePointer);
                        while (((GCClassIteratorClassSlots)object).hasNext()) {
                            J9ClassPointer j9ClassPointer = ((GCClassIteratorClassSlots)object).next();
                            J9ObjectPointer j9ObjectPointer2 = ConstantPoolHelpers.J9VM_J9CLASS_TO_HEAPCLASS(j9ClassPointer);
                            if (!j9ObjectPointer2.notNull()) continue;
                            this.checkField(j9ObjectPointer, j9ObjectPointer2);
                        }
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                return false;
            }
            return true;
        }

        @Override
        public void finishVisit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        }

        private void checkField(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2) throws CorruptDataException {
            MM_HeapRegionDescriptorVLHGCPointer mM_HeapRegionDescriptorVLHGCPointer;
            MM_AllocationContextTarokPointer mM_AllocationContextTarokPointer;
            GCHeapRegionDescriptor gCHeapRegionDescriptor = this.heapRegionManager.regionDescriptorForAddress(j9ObjectPointer2);
            if (gCHeapRegionDescriptor == null) {
                gCHeapRegionDescriptor = null;
            }
            if ((mM_AllocationContextTarokPointer = (mM_HeapRegionDescriptorVLHGCPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(gCHeapRegionDescriptor.getHeapRegionDescriptorPointer()))._allocateData()._owningContext()).eq(this.allocationContext)) {
                J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
                String string = J9ClassHelper.getJavaName(j9ClassPointer);
                J9ClassPointer j9ClassPointer2 = J9ObjectHelper.clazz(j9ObjectPointer2);
                String string2 = J9ClassHelper.getJavaName(j9ClassPointer2);
                this.table.row("!j9object " + j9ObjectPointer.getHexAddress() + " //" + string, "!j9object " + j9ObjectPointer2.getHexAddress() + " //" + string2);
                ++this.numExternalReferences;
            }
        }

        public int getNumExternalReferencesFound() {
            return this.numExternalReferences;
        }
    }
}

