/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMClassSlots
extends Check {
    CheckVMClassSlots() {
    }

    @Override
    public void check() {
        try {
            GCVMClassSlotIterator gCVMClassSlotIterator = GCVMClassSlotIterator.from();
            while (gCVMClassSlotIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = gCVMClassSlotIterator.next();
                if (!j9ClassPointer.notNull() || this._engine.checkJ9ClassPointer(j9ClassPointer) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "VM CLASS SLOTS";
    }

    @Override
    public void print() {
        try {
            GCVMClassSlotIterator gCVMClassSlotIterator = GCVMClassSlotIterator.from();
            ScanFormatter scanFormatter = new ScanFormatter(this, "VMClass Slot");
            while (gCVMClassSlotIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = gCVMClassSlotIterator.next();
                if (!j9ClassPointer.notNull()) continue;
                scanFormatter.entry(j9ClassPointer);
            }
            scanFormatter.end("VMClass Slot");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

