/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.commands.xcommands.XCommand;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class XKCommand
extends XCommand {
    public XKCommand() {
        this.addCommand("x/k", "<hex address>", "displays the specified memory section as if it were a stack frame parameters");
    }

    @Override
    public boolean recognises(String string, IContext iContext) {
        if (super.recognises(string, iContext)) {
            return string.toLowerCase().endsWith("k");
        }
        return false;
    }

    @Override
    public void doCommand(String[] stringArray) {
        String string = stringArray[0];
        Long l = Utils.longFromStringWithPrefix(string);
        if (null == l) {
            this.out.println("invalid hex address specified; address must be specified as \"0x<hex_address>\"");
            return;
        }
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        int n = this.getIASPointerSize(imageAddressSpace);
        int n2 = n > 32 ? 8 : 4;
        this.out.print("\n");
        for (int i = 0; i < this.argUnitNumber; ++i) {
            boolean bl = false;
            long l2 = l + (long)(i * n2);
            ImagePointer imagePointer = imageAddressSpace.getPointer(l2);
            this.out.print("\t");
            this.out.print(Utils.toHex(l2));
            this.out.print("   ");
            long l3 = 0L;
            try {
                l3 = imagePointer.getPointerAt(0L).getAddress();
                bl = true;
            }
            catch (CorruptDataException corruptDataException) {
                bl = false;
            }
            catch (MemoryAccessException memoryAccessException) {
                bl = false;
            }
            if (bl) {
                long l4 = l3;
                this.out.print(this.toAdjustedHex(l3, n));
                this.out.print("   ");
                if (31 == n) {
                    l4 = (int)(l4 & (1L << n) - 1L);
                }
                if (this.printSymbol(l4, l3 - l2, n) || this.printStackPointer(l4, l3 - l2, n, imageAddressSpace)) {
                    // empty if block
                }
                this.out.print("\n");
                continue;
            }
            this.out.print("<address not found in any address space or exception occurred>\n");
        }
        this.out.print("\n");
    }

    private boolean printSymbol(long l, long l2, int n) {
        Iterator iterator;
        ImageProcess imageProcess = this.ctx.getProcess();
        try {
            iterator = imageProcess.getLibraries();
        }
        catch (CorruptDataException corruptDataException) {
            iterator = null;
        }
        catch (DataUnavailable dataUnavailable) {
            iterator = null;
        }
        while (null != iterator && iterator.hasNext()) {
            ImageModule imageModule = (ImageModule)iterator.next();
            Iterator iterator2 = imageModule.getSections();
            while (iterator2.hasNext()) {
                ImageSection imageSection = (ImageSection)iterator2.next();
                long l3 = imageSection.getBaseAddress().getAddress();
                long l4 = l3 + imageSection.getSize();
                if (l < l3 || l >= l4) continue;
                long l5 = l - l3;
                ImageSymbol imageSymbol = null;
                Iterator iterator3 = imageModule.getSymbols();
                while (iterator3.hasNext()) {
                    ImageSymbol imageSymbol2;
                    long l6;
                    Object e = iterator3.next();
                    if (e instanceof CorruptData || (l6 = (imageSymbol2 = (ImageSymbol)e).getAddress().getAddress()) > l || l - l6 >= l5) continue;
                    l5 = l - l6;
                    imageSymbol = imageSymbol2;
                }
                try {
                    this.out.print(imageModule.getName());
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                }
                this.out.print("::");
                if (imageSymbol == null) {
                    this.out.print(imageSection.getName());
                } else {
                    this.out.print(imageSymbol.getName());
                }
                this.out.print("+");
                this.out.print(Long.toString(l5));
                return true;
            }
        }
        return false;
    }

    private boolean printStackPointer(long l, long l2, int n, ImageAddressSpace imageAddressSpace) {
        if (Math.abs(l2) <= 4096L) {
            if (l2 < 0L) {
                this.out.print(" .");
                this.out.print(Long.toString(l2));
            } else {
                this.out.print(" .+");
                this.out.print(Long.toString(l2));
            }
            return true;
        }
        return false;
    }

    private int getIASPointerSize(ImageAddressSpace imageAddressSpace) {
        return ((ImageProcess)imageAddressSpace.getProcesses().next()).getPointerSize();
    }

    private String toAdjustedHex(long l, int n) {
        if (n > 32) {
            return Utils.toFixedWidthHex(l);
        }
        if (31 == n) {
            return Utils.toFixedWidthHex((int)(l & (1L << n) - 1L));
        }
        return Utils.toFixedWidthHex((int)l);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        super.printDetailedHelp(printStream);
        printStream.println("displays the specified memory section as if it were a stack frame\n\nparameters: 0x<addr>\n\nDisplays the value of each section (whose size is defined by the pointer size of this architecture) of memory, adjusted for the endianness of the architecture this dump file is from, starting at the specified address.  It also displays a module with a module section and an offset from the start of that module section in memory if the pointer points to that module section.  If no symbol is found, it displays a \"*\" and an offset from the current address if the pointer points to an address within 4KB (4096 bytes) of the current address.\n\nWhile this command can work on an arbitrary section of memory, it is probably most useful when used on a section of memory that refers to a stack frame.  To find the memory section of a thread's stack frame, use the \"info thread\" command.\n\nNote: This command uses the number of items passed to it by the \"x/\" command, but ignores the unit size.\n");
    }
}

