/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.IStringModifier;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TokensTool
extends Tool
implements IPipe {
    private static final String COMMAND = "tokens";
    private static final String RANGE_INDICATOR = "..";
    private static final String OPTION_KEEP = "-keep";
    private static final String ARGUMENT_DESCRIPTION = "[-keep] <range>[,<range>...]";
    private static final String HELP_DESCRIPTION = "To be used after a pipeline to pick up tokens in a line.";
    private static final String USAGE = "tokens\t[-keep] <range>[,<range>...]\tTo be used after a pipeline to pick up tokens in a line.\n     A range can be defined in the following formats:\n          X\n          X..Y\n     In the latter format, if X is missing, it is assumed to be 1 (representing the first token).\n     If Y is missing, it is assumed to be -1 (representing the last token).\n     X or Y can be preceded by a minus sign (-), which implies counting from the right.\n     X has to represent a position (that can be) the same or to the left of what Y represents.\n     \n     A range is present if it includes at least one token.\n     The output consists of the selected tokens, in the order specified; a single space separates output tokens.\n     If all the ranges are missing from the line, the line is suppressed unless the -keep option is used.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        Arguments arguments = TokensTool.processArguments(stringArray, printStream);
        if (arguments == null) {
            printStream.println(USAGE);
            return;
        }
        try (PrintStream printStream2 = null;){
            printStream2 = new PrintStream(new OutputStreamModifier(printStream, new StringModifier(arguments)));
            ToolsRegistry.process(arguments.nextCommand, arguments.nextCommandArgs, printStream2);
        }
    }

    @Override
    public boolean accept(String string, String[] stringArray) {
        return COMMAND.equalsIgnoreCase(string);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private static Arguments processArguments(String[] stringArray, PrintStream printStream) {
        Object object;
        if (stringArray.length < 2) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        ArrayList<Range> arrayList = new ArrayList<Range>();
        if (stringArray[n].equalsIgnoreCase(OPTION_KEEP)) {
            bl = true;
            ++n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ",");
        while (stringTokenizer.hasMoreTokens()) {
            object = TokensTool.parseRange(stringTokenizer.nextToken(), printStream);
            if (object == null) {
                return null;
            }
            arrayList.add((Range)object);
        }
        if (stringArray[++n].equalsIgnoreCase(OPTION_KEEP)) {
            bl = true;
            ++n;
        }
        object = stringArray[n];
        int n2 = n + 1;
        String[] stringArray2 = new String[stringArray.length - n2];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + n2];
        }
        return new Arguments(bl, arrayList, (String)object, stringArray2);
    }

    private static Range parseRange(String string, PrintStream printStream) {
        int n = 1;
        int n2 = -1;
        int n3 = string.indexOf(RANGE_INDICATOR);
        try {
            if (n3 < 0) {
                n2 = n = Integer.parseInt(string);
            } else {
                String string2;
                String string3 = string.substring(0, n3);
                if (string3.length() > 0) {
                    n = Integer.parseInt(string3);
                }
                if ((string2 = string.substring(n3 + RANGE_INDICATOR.length())).length() > 0) {
                    n2 = Integer.parseInt(string2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            printStream.println("Range must be numeric : " + string);
            return null;
        }
        if (n == 0 || n2 == 0 || n * n2 > 0 && n > n2) {
            printStream.println("Invalid range : " + string);
            return null;
        }
        return new Range(n, n2);
    }

    private static final class StringModifier
    implements IStringModifier {
        private final Arguments arguments;

        public StringModifier(Arguments arguments) {
            this.arguments = arguments;
        }

        @Override
        public String modify(String string) {
            StringBuilder stringBuilder = null;
            List<String> list = StringModifier.tokenize(string);
            int n = list.size();
            for (Range range : this.arguments.rangeList) {
                int n2 = range.getEndIndex(n);
                for (int i = range.getStartIndex(n); i <= n2; ++i) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(list.get(i));
                }
            }
            if (stringBuilder == null || stringBuilder.length() == 0) {
                if (this.arguments.keep) {
                    return string.endsWith("\n") ? string : string + "\n";
                }
                return "";
            }
            return stringBuilder.toString() + "\n";
        }

        private static List<String> tokenize(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }
    }

    private static final class Arguments {
        public final String nextCommand;
        public final String[] nextCommandArgs;
        public final boolean keep;
        public final List<Range> rangeList;

        public Arguments(boolean bl, List<Range> list, String string, String[] stringArray) {
            this.keep = bl;
            this.rangeList = list;
            this.nextCommand = string;
            this.nextCommandArgs = stringArray;
        }
    }

    private static final class Range {
        final int start;
        final int end;

        public Range(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStartIndex(int n) {
            return Math.max(0, this.start < 0 ? n + this.start : this.start - 1);
        }

        public int getEndIndex(int n) {
            return Math.min(n - 1, this.end < 0 ? n + this.end : this.end - 1);
        }
    }
}

