/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaStaticField;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Vector;

public class JavaClass
extends JavaAbstractClass {
    private long _superClassID;
    private String _className;
    private Vector _methods = new Vector();
    private Vector _fields = new Vector();
    private Vector _constantPoolClassRefs = new Vector();
    private Vector _constantPoolObjects = new Vector();
    private int _instanceSize;
    private String _fileName;

    public JavaClass(JavaRuntime javaRuntime, ImagePointer imagePointer, long l, String string, int n, long l2, int n2, int n3, String string2, ImagePointer imagePointer2, int n4) {
        super(javaRuntime, imagePointer, n2, l2, imagePointer2, n3, n4);
        this._superClassID = l;
        this._className = string;
        this._instanceSize = n;
        this._fileName = string2;
    }

    @Override
    public String getName() throws CorruptDataException {
        return this._className;
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getSuperclass() throws CorruptDataException {
        if (this._superClassID == 0L) {
            return null;
        }
        if (Modifier.isInterface(this.getModifiers())) {
            return null;
        }
        com.ibm.dtfj.java.JavaClass javaClass = this._javaVM.getClassForID(this._superClassID);
        if (javaClass == null) {
            throw new CorruptDataException(new CorruptData("Unknown superclass ID " + this._superClassID, null));
        }
        return javaClass;
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return false;
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getComponentType() throws CorruptDataException {
        throw new IllegalArgumentException("Only array types have component types");
    }

    @Override
    public Iterator getDeclaredFields() {
        return this._fields.iterator();
    }

    @Override
    public Iterator getDeclaredMethods() {
        return this._methods.iterator();
    }

    @Override
    public Iterator getConstantPoolReferences() {
        Object object;
        Iterator iterator = this._constantPoolClassRefs.iterator();
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            Object object2 = null;
            object = this._javaVM.getClassForID(l);
            if (object == null) {
                object2 = new CorruptData("Unknown class in constant pool " + l, null);
            } else {
                try {
                    object2 = object.getObject();
                }
                catch (CorruptDataException corruptDataException) {
                    object2 = corruptDataException.getCorruptData();
                }
                catch (Exception exception) {
                    object2 = new CorruptData(exception.getMessage());
                }
            }
            vector.add(object2);
        }
        for (int i = 0; i < this._constantPoolObjects.size(); ++i) {
            try {
                long l = (Long)this._constantPoolObjects.get(i);
                if (l == 0L) continue;
                object = this._javaVM.pointerInAddressSpace(l);
                try {
                    JavaObject javaObject = this._javaVM.getObjectAtAddress((ImagePointer)object);
                    vector.add(javaObject);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    vector.add(new CorruptData(illegalArgumentException.getMessage(), (ImagePointer)object));
                }
                continue;
            }
            catch (CorruptDataException corruptDataException) {
                vector.add(corruptDataException.getCorruptData());
            }
        }
        return vector.iterator();
    }

    public void addConstantPoolClassRef(long l) {
        if (0L != l) {
            this._constantPoolClassRefs.add(l);
        }
    }

    @Override
    public int getInstanceSize(JavaObject javaObject) {
        return this._instanceSize;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        if (this._fileName != null) {
            return this._fileName;
        }
        throw new DataUnavailable();
    }

    public void createNewField(String string, String string2, int n, int n2, long l) {
        if (this.getID().getAddress() == l) {
            JavaInstanceField javaInstanceField = new JavaInstanceField(this._javaVM, string, string2, n, n2, l);
            this._fields.add(javaInstanceField);
        }
    }

    public JavaMethod createNewMethod(long l, String string, String string2, int n) {
        JavaMethod javaMethod = new JavaMethod(this._javaVM.pointerInAddressSpace(l), string, string2, n, this);
        this._javaVM.addMethodForID(javaMethod, l);
        this._methods.add(javaMethod);
        return javaMethod;
    }

    public void createConstantPoolObjectRef(long l) {
        this._constantPoolObjects.add(l);
    }

    public void createNewStaticField(String string, String string2, int n, String string3) {
        JavaStaticField javaStaticField = new JavaStaticField(this._javaVM, string, string2, n, string3, this.getID().getAddress());
        this._fields.add(javaStaticField);
    }

    public String toString() {
        return this._className + "@" + Long.toHexString(this._classPointer.getAddress());
    }

    @Override
    public Iterator getReferences() {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        JavaReference javaReference = null;
        Iterator iterator = this.getConstantPoolReferences();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof JavaObject) {
                javaReference = new JavaReference(this._javaVM, (Object)this, object2, "Constant Pool Object", 9, 0, 1);
            } else if (object2 instanceof JavaClass) {
                object = (JavaClass)object2;
                javaReference = new JavaReference(this._javaVM, (Object)this, object, "Constant Pool Class", 9, 0, 1);
            }
            if (null == javaReference) continue;
            vector.add(javaReference);
        }
        object2 = this.getDeclaredFields();
        while (object2.hasNext()) {
            String string;
            Object object3;
            object = (JavaField)object2.next();
            if (!(object instanceof JavaStaticField)) continue;
            JavaStaticField javaStaticField = (JavaStaticField)object;
            try {
                Object object4 = javaStaticField.getReferenceType(null);
                if (null == object4 || !(object4 instanceof JavaObject)) continue;
                object3 = javaStaticField.getName();
                string = "Static field";
                if (null != object3) {
                    string = string + " [field name:" + (String)object3 + "]";
                }
                JavaObject javaObject = (JavaObject)object4;
                javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, string, 8, 0, 1);
                vector.add(javaReference);
            }
            catch (CorruptDataException corruptDataException) {
                vector.add(corruptDataException.getCorruptData());
            }
            catch (MemoryAccessException memoryAccessException) {
                object3 = memoryAccessException.getPointer();
                string = memoryAccessException.getMessage();
                vector.add(new CorruptData(string, (ImagePointer)object3));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.addSuperclassReference(vector);
        this.addClassLoaderReference(vector);
        this.addClassObjectReference(vector);
        return vector.iterator();
    }

    public boolean isAncestorOf(com.ibm.dtfj.java.JavaClass javaClass) {
        if (null == javaClass) {
            return false;
        }
        if (this.equals(javaClass)) {
            return true;
        }
        try {
            return this.isAncestorOf(javaClass.getSuperclass());
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
    }

    @Override
    public long getInstanceSize() throws CorruptDataException {
        return this._instanceSize;
    }
}

