/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.management.ObjectName;
import openj9.management.internal.ThreadInfoBase;

public class ThreadMXBeanImpl
implements ThreadMXBean {
    private static final ThreadMXBeanImpl instance = new ThreadMXBeanImpl();
    private static Boolean isThreadCpuTimeEnabled = null;
    private static Boolean isThreadCpuTimeSupported = null;
    private static final MethodHandle threadInfoConstructorHandle = ThreadMXBeanImpl.getThreadInfoConstructorHandle();
    private ObjectName objectName;

    protected ThreadMXBeanImpl() {
    }

    public static ThreadMXBean getInstance() {
        return instance;
    }

    private native long[] findMonitorDeadlockedThreadsImpl();

    @Override
    public long[] findMonitorDeadlockedThreads() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findMonitorDeadlockedThreadsImpl();
    }

    private native long[] getAllThreadIdsImpl();

    @Override
    public long[] getAllThreadIds() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.getAllThreadIdsImpl();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        long l = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l = this.getThreadCpuTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return l;
    }

    @Override
    public long getCurrentThreadUserTime() {
        long l = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l = this.getThreadUserTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return l;
    }

    private native int getDaemonThreadCountImpl();

    @Override
    public int getDaemonThreadCount() {
        return this.getDaemonThreadCountImpl();
    }

    private native int getPeakThreadCountImpl();

    @Override
    public int getPeakThreadCount() {
        return this.getPeakThreadCountImpl();
    }

    private native int getThreadCountImpl();

    @Override
    public int getThreadCount() {
        return this.getThreadCountImpl();
    }

    private native long getThreadCpuTimeImpl(long var1);

    @Override
    public long getThreadCpuTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long l2 = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l2 = this.getThreadCpuTimeImpl(l);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return l2;
    }

    @Override
    public ThreadInfo getThreadInfo(long l) {
        return this.getThreadInfo(l, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long l : lArray) {
            if (l > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        ThreadInfoBase[] threadInfoBaseArray = this.getMultiThreadInfoImpl(lArray, n, false, false);
        return ThreadMXBeanImpl.makeThreadInfos(threadInfoBaseArray);
    }

    private static ThreadInfo[] makeThreadInfos(ThreadInfoBase[] threadInfoBaseArray) {
        PrivilegedAction<ThreadInfo[]> privilegedAction = () -> (ThreadInfo[])Arrays.stream(threadInfoBaseArray).map(ThreadMXBeanImpl::makeThreadInfo).toArray(ThreadInfo[]::new);
        return AccessController.doPrivileged(privilegedAction);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        return this.getThreadInfoCommon(lArray, bl, bl2, Integer.MAX_VALUE);
    }

    private ThreadInfo[] getThreadInfoCommon(long[] lArray, boolean bl, boolean bl2, int n) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long l : lArray) {
            if (l > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        return ThreadMXBeanImpl.makeThreadInfos(this.getMultiThreadInfoImpl(lArray, n, bl, bl2));
    }

    @Override
    public ThreadInfo getThreadInfo(long l, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (l <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        PrivilegedAction<ThreadInfo> privilegedAction = () -> ThreadMXBeanImpl.makeThreadInfo(this.getThreadInfoImpl(l, n));
        return AccessController.doPrivileged(privilegedAction);
    }

    private native ThreadInfoBase getThreadInfoImpl(long var1, int var3);

    private native long getThreadUserTimeImpl(long var1);

    @Override
    public long getThreadUserTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long l2 = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l2 = this.getThreadUserTimeImpl(l);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return l2;
    }

    private native long getTotalStartedThreadCountImpl();

    @Override
    public long getTotalStartedThreadCount() {
        return this.getTotalStartedThreadCountImpl();
    }

    private native boolean isCurrentThreadCpuTimeSupportedImpl();

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.isCurrentThreadCpuTimeSupportedImpl();
    }

    private native boolean isThreadContentionMonitoringEnabledImpl();

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        return this.isThreadContentionMonitoringEnabledImpl();
    }

    private native boolean isThreadContentionMonitoringSupportedImpl();

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.isThreadContentionMonitoringSupportedImpl();
    }

    private native boolean isThreadCpuTimeEnabledImpl();

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        if (isThreadCpuTimeEnabled == null) {
            isThreadCpuTimeEnabled = this.isThreadCpuTimeEnabledImpl();
        }
        return isThreadCpuTimeEnabled;
    }

    private native boolean isThreadCpuTimeSupportedImpl();

    @Override
    public boolean isThreadCpuTimeSupported() {
        if (isThreadCpuTimeSupported == null) {
            isThreadCpuTimeSupported = this.isThreadCpuTimeSupportedImpl();
        }
        return isThreadCpuTimeSupported;
    }

    private native void resetPeakThreadCountImpl();

    @Override
    public void resetPeakThreadCount() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakThreadCountImpl();
    }

    private native void setThreadContentionMonitoringEnabledImpl(boolean var1);

    @Override
    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadContentionMonitoringEnabledImpl(bl);
    }

    private native void setThreadCpuTimeEnabledImpl(boolean var1);

    @Override
    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadCpuTimeEnabledImpl(bl);
        isThreadCpuTimeEnabled = bl;
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.isObjectMonitorUsageSupportedImpl();
    }

    private native boolean isObjectMonitorUsageSupportedImpl();

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.isSynchronizerUsageSupportedImpl();
    }

    private native boolean isSynchronizerUsageSupportedImpl();

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findDeadlockedThreadsImpl();
    }

    private native long[] findDeadlockedThreadsImpl();

    @Override
    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        return this.dumpAllThreadsCommon(bl, bl2, Integer.MAX_VALUE);
    }

    private ThreadInfo[] dumpAllThreadsCommon(boolean bl, boolean bl2, int n) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        ThreadInfoBase[] threadInfoBaseArray = this.dumpAllThreadsImpl(bl, bl2, n);
        return ThreadMXBeanImpl.makeThreadInfos(threadInfoBaseArray);
    }

    private native ThreadInfoBase[] dumpAllThreadsImpl(boolean var1, boolean var2, int var3);

    private native ThreadInfoBase[] getMultiThreadInfoImpl(long[] var1, int var2, boolean var3, boolean var4);

    public long[] getNativeThreadIds(long[] lArray) throws IllegalArgumentException, SecurityException {
        long[] lArray2;
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long l : lArray2 = (long[])lArray.clone()) {
            if (l > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05FD", l));
        }
        long[] lArray3 = new long[lArray.length];
        this.getNativeThreadIdsImpl(lArray2, lArray3);
        return lArray3;
    }

    public long getNativeThreadId(long l) throws IllegalArgumentException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (l <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FD", l));
        }
        return ThreadMXBeanImpl.findNativeThreadIDImpl(l);
    }

    private static native long findNativeThreadIDImpl(long var0);

    private native void getNativeThreadIdsImpl(long[] var1, long[] var2);

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.lang:type=Threading");
        }
        return this.objectName;
    }

    private static MethodHandle getThreadInfoConstructorHandle() {
        return AccessController.doPrivileged(new PrivilegedAction<MethodHandle>(){

            @Override
            public MethodHandle run() {
                MethodHandle methodHandle = null;
                try {
                    Constructor constructor = ThreadInfo.class.getDeclaredConstructor(ThreadInfoBase.class);
                    constructor.setAccessible(true);
                    methodHandle = MethodHandles.lookup().unreflectConstructor(constructor);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException exception) {
                    throw new RuntimeException(Msg.getString("K0617"), exception);
                }
                return methodHandle;
            }
        });
    }

    private static ThreadInfo makeThreadInfo(ThreadInfoBase threadInfoBase) {
        ThreadInfo threadInfo = null;
        if (null != threadInfoBase && null != threadInfoConstructorHandle) {
            try {
                threadInfo = threadInfoConstructorHandle.invoke(threadInfoBase);
            }
            catch (Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(Msg.getString("K0618"), throwable);
            }
        }
        return threadInfo;
    }
}

