/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import com.ibm.oti.shared.SharedHelper;
import com.ibm.oti.util.Msg;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;

public abstract class SharedAbstractHelper
implements SharedHelper {
    private Boolean verbose;
    private WeakReference<ClassLoader> loaderRef;
    private SharedClassPermission readPerm;
    private SharedClassPermission writePerm;
    boolean canFind;
    boolean canStore;
    int id;

    void initialize(ClassLoader classLoader, int n, boolean bl, boolean bl2) {
        this.id = n;
        this.canFind = bl;
        this.canStore = bl2;
        this.loaderRef = new WeakReference<ClassLoader>(classLoader);
        this.printVerboseInfo(Msg.getString("K0591", (Object)this.getHelperType(), this.id));
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loaderRef.get();
    }

    private native boolean getIsVerboseImpl();

    private static boolean checkPermission(SecurityManager securityManager, ClassLoader classLoader, String string) {
        boolean bl = false;
        try {
            securityManager.checkPermission(new SharedClassPermission(classLoader, string));
            bl = true;
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return bl;
    }

    static boolean checkReadPermission(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return SharedAbstractHelper.checkPermission(securityManager, classLoader, "read");
        }
        return true;
    }

    static boolean checkWritePermission(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return SharedAbstractHelper.checkPermission(securityManager, classLoader, "write");
        }
        return true;
    }

    private boolean isVerbose() {
        if (this.verbose == null) {
            boolean bl = this.getIsVerboseImpl();
            this.verbose = bl;
            if (bl) {
                this.printVerboseInfo(Msg.getString("K0592", (Object)this.getHelperType(), this.id));
            }
        }
        return this.verbose;
    }

    void printVerboseError(String string) {
        if (this.isVerbose()) {
            System.err.println(Msg.getString("K0593", this.getHelperType(), Integer.toString(this.id), string));
        }
    }

    void printVerboseInfo(String string) {
        if (this.isVerbose()) {
            System.err.println(Msg.getString("K0594", this.getHelperType(), Integer.toString(this.id), string));
        }
    }

    abstract String getHelperType();
}

