/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class AuthorizationDataEntry
implements Cloneable {
    public int adType;
    public byte[] adData;

    private AuthorizationDataEntry() {
    }

    public AuthorizationDataEntry(int n, byte[] byArray) {
        this.adType = n;
        this.adData = byArray;
    }

    public Object clone() {
        AuthorizationDataEntry authorizationDataEntry = new AuthorizationDataEntry();
        authorizationDataEntry.adType = this.adType;
        if (this.adData != null) {
            authorizationDataEntry.adData = new byte[this.adData.length];
            System.arraycopy((Object)this.adData, 0, (Object)authorizationDataEntry.adData, 0, this.adData.length);
        }
        return authorizationDataEntry;
    }

    public AuthorizationDataEntry(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.adType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.adData = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.adType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.adData);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public void writeEntry(CCacheOutputStream cCacheOutputStream) throws IOException {
        cCacheOutputStream.write16(this.adType);
        cCacheOutputStream.write32(this.adData.length);
        cCacheOutputStream.write(this.adData, 0, this.adData.length);
    }

    public String toString() {
        return "adType=" + this.adType + " adData.length=" + this.adData.length;
    }
}

