/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import java.util.Iterator;

public class GCJNIGlobalReferenceIterator
extends GCIterator {
    protected Iterator<PointerPointer> iterator;

    protected GCJNIGlobalReferenceIterator(J9PoolPointer j9PoolPointer) throws CorruptDataException {
        this.iterator = Pool.fromJ9Pool(j9PoolPointer, PointerPointer.class).iterator();
    }

    public static GCJNIGlobalReferenceIterator from() throws CorruptDataException {
        return new GCJNIGlobalReferenceIterator(GCJNIGlobalReferenceIterator.getJavaVM().jniGlobalReferences());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        try {
            PointerPointer pointerPointer = this.iterator.next();
            return J9ObjectPointer.cast(pointerPointer.at(0L));
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        return VoidPointer.cast(this.iterator.next());
    }
}

