/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.DoublePointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.I16Pointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.PrintObjectFieldsHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.types.U32;
import java.io.PrintStream;
import java.util.List;

public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    public static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    public static final int DEFAULT_ARRAY_FORMAT_END = 16;

    @Override
    public FormatWalkResult format(String string, long l, PrintStream printStream, Context context, List<IFieldFormatter> list, String[] stringArray) {
        if (string.equalsIgnoreCase("j9object") || string.equalsIgnoreCase("j9indexableobject")) {
            J9ClassPointer j9ClassPointer = null;
            J9ObjectPointer j9ObjectPointer = null;
            try {
                j9ObjectPointer = J9ObjectPointer.cast(l);
                j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
                if (j9ClassPointer.isNull()) {
                    printStream.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                boolean bl = J9ClassHelper.isArrayClass(j9ClassPointer);
                String string2 = J9UTF8Helper.stringValue(j9ClassPointer.romClass().className());
                U8Pointer u8Pointer = U8Pointer.cast(j9ObjectPointer).add(ObjectModel.getHeaderSize(j9ObjectPointer));
                if (string2.equals("java/lang/String")) {
                    this.formatStringObject(printStream, 0, j9ClassPointer, u8Pointer, j9ObjectPointer, l);
                } else if (bl) {
                    if (ValueTypeHelper.getValueTypeHelper().isJ9ClassIsFlattened(j9ClassPointer) && stringArray.length > 0 && stringArray[0].startsWith("[")) {
                        this.formatObject(printStream, J9ArrayClassPointer.cast(j9ClassPointer).componentType(), u8Pointer, j9ObjectPointer, l, stringArray);
                    } else {
                        int n = 0;
                        int n2 = 16;
                        if (stringArray.length > 0) {
                            n = Integer.parseInt(stringArray[0]);
                        }
                        if (stringArray.length > 1) {
                            n2 = Integer.parseInt(stringArray[1]);
                        }
                        this.formatArrayObject(printStream, j9ClassPointer, u8Pointer, J9IndexableObjectPointer.cast(j9ObjectPointer), n, n2);
                    }
                } else {
                    this.formatObject(printStream, j9ClassPointer, u8Pointer, j9ObjectPointer, l, stringArray);
                }
            }
            catch (MemoryFault memoryFault) {
                printStream.println("Unable to read object clazz at " + (j9ObjectPointer == null ? "(null)" : j9ObjectPointer.getHexAddress()) + " (clazz = " + (j9ClassPointer == null ? "(null)" : j9ClassPointer.getHexAddress()) + ")");
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println("Error for ");
                corruptDataException.printStackTrace(printStream);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatObject(PrintStream printStream, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer, long l, String[] stringArray) throws CorruptDataException {
        String[] stringArray2 = null;
        if (ValueTypeHelper.getValueTypeHelper().areValueTypesSupported()) {
            String[] stringArray3 = stringArray2 = stringArray.length == 0 ? null : stringArray[0].split("\\.");
        }
        if (null != stringArray2) {
            printStream.format("!J9Object %s %s {%n", j9ObjectPointer.getHexAddress(), stringArray[0]);
        } else {
            printStream.format("!J9Object %s {%n", j9ObjectPointer.getHexAddress());
        }
        PrintObjectFieldsHelper.printJ9ObjectFields(printStream, 1, j9ClassPointer, u8Pointer, j9ObjectPointer, l, stringArray2, false);
        printStream.println("}");
    }

    private void formatArrayObject(PrintStream printStream, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
        printStream.format("!J9IndexableObject %s {%n", j9IndexableObjectPointer.getHexAddress());
        printStream.format("    struct J9Class* clazz = !j9arrayclass 0x%X   // %s%n", j9ClassPointer.getAddress(), string);
        printStream.format("    Object flags = %s;%n", J9IndexableObjectHelper.flags(j9IndexableObjectPointer).getHexValue());
        U32 u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (u32.anyBitsIn(Integer.MIN_VALUE)) {
            printStream.format("    U_32 size = %s; // Size exceeds Integer.MAX_VALUE!%n", u32.getHexValue());
        } else {
            printStream.format("    U_32 size = %s;%n", u32.getHexValue());
        }
        this.printSubArrayType(printStream, 1, j9ClassPointer, u8Pointer, n, n2, j9IndexableObjectPointer);
        printStream.println("}");
    }

    void printSubArrayType(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, int n2, int n3, J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        int n4;
        U32 u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (u32.anyBitsIn(Integer.MIN_VALUE)) {
            u32 = new U32(Integer.MAX_VALUE);
        }
        if (n2 < (n4 = Math.min(u32.intValue(), n3))) {
            String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
            char c = string.charAt(1);
            switch (c) {
                case 'B': 
                case 'Z': {
                    for (int i = n2; i < n4; ++i) {
                        PrintObjectFieldsHelper.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 1);
                        printStream.format("[%d] = %3d, 0x%02x%n", i, U8Pointer.cast(voidPointer).at(0L).longValue(), U8Pointer.cast(voidPointer).at(0L).longValue());
                    }
                    break;
                }
                case 'C': {
                    for (int i = n2; i < n4; ++i) {
                        PrintObjectFieldsHelper.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 2);
                        long l = U16Pointer.cast(voidPointer).at(0L).longValue();
                        printStream.format("[%d] = %5d, 0x%2$04x, '%c'%n", i, l, Character.valueOf((char)l));
                    }
                    break;
                }
                case 'S': {
                    for (int i = n2; i < n4; ++i) {
                        PrintObjectFieldsHelper.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 2);
                        printStream.format("[%d] = %6d, 0x%04x%n", i, I16Pointer.cast(voidPointer).at(0L).longValue(), U16Pointer.cast(voidPointer).at(0L).longValue());
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    for (int i = n2; i < n4; ++i) {
                        PrintObjectFieldsHelper.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 4);
                        printStream.format("[%d] = %10d, 0x%08x, %8.8fF%n", i, I32Pointer.cast(voidPointer).at(0L).longValue(), U32Pointer.cast(voidPointer).at(0L).longValue(), Float.valueOf(FloatPointer.cast(voidPointer).floatAt(0L)));
                    }
                    break;
                }
                case 'D': 
                case 'J': {
                    for (int i = n2; i < n4; ++i) {
                        PrintObjectFieldsHelper.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 8);
                        printStream.format("[%d] = %2d, 0x%016x, %8.8fF%n", i, I64Pointer.cast(voidPointer).at(0L).longValue(), I64Pointer.cast(voidPointer).at(0L).longValue(), DoublePointer.cast(voidPointer).doubleAt(0L));
                    }
                    break;
                }
                case 'L': 
                case '[': {
                    if (ValueTypeHelper.getValueTypeHelper().isJ9ClassIsFlattened(j9ClassPointer)) {
                        this.formatFlattenedObjectArray(printStream, n, n2, n4, j9IndexableObjectPointer);
                        break;
                    }
                    this.formatReferenceObjectArray(printStream, n, j9ClassPointer, n2, n4, j9IndexableObjectPointer);
                }
            }
        }
        u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (n2 > 0 || u32.longValue() > (long)n4) {
            printStream.format("To print entire range: !j9indexableobject %s %d %d%n", j9IndexableObjectPointer.getHexAddress(), 0, u32.longValue());
        }
    }

    private void formatReferenceObjectArray(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, int n2, int n3, J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        for (int i = n2; i < n3; ++i) {
            VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, (int)ObjectReferencePointer.SIZEOF);
            long l = J9BuildFlags.gc_compressedPointers ? U32Pointer.cast(voidPointer).at(0L).longValue() : DataType.getProcess().getPointerAt(voidPointer.getAddress());
            PrintObjectFieldsHelper.padding(printStream, n);
            if (l != 0L) {
                printStream.format("[%d] = !fj9object 0x%x = !j9object 0x%x%n", i, l, ObjectReferencePointer.cast(voidPointer).at(0L).longValue());
                continue;
            }
            printStream.format("[%d] = null%n", i);
        }
    }

    private void formatFlattenedObjectArray(PrintStream printStream, int n, int n2, int n3, J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        for (int i = n2; i < n3; ++i) {
            PrintObjectFieldsHelper.padding(printStream, n);
            printStream.format("[%d] = !j9object 0x%x [%d]%n", i, j9IndexableObjectPointer.getAddress(), i);
        }
    }

    private void formatStringObject(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer, long l) throws CorruptDataException {
        printStream.format("J9VMJavaLangString at %s {%n", j9ObjectPointer.getHexAddress());
        PrintObjectFieldsHelper.printJ9ObjectFields(printStream, n, j9ClassPointer, u8Pointer, j9ObjectPointer, l);
        PrintObjectFieldsHelper.padding(printStream, n);
        printStream.format("\"%s\"%n", J9ObjectHelper.stringValue(j9ObjectPointer));
        printStream.println("}");
    }
}

