/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.MissingDataException;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePointDebugInfo;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceRecord;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TraceThread
implements Comparable {
    TraceContext context;
    BigInteger timerUpperWord = BigInteger.ZERO;
    BigInteger newestWrapTime = BigInteger.ZERO;
    long threadLostRecordCount = 0L;
    long threadRecordCount = 0L;
    protected long threadID = 0L;
    protected long nativeThreadID = 0L;
    protected String threadName = "";
    private Long threadIdentifier = null;
    protected ByteStream stream = null;
    TracePointImpl next = null;
    TracePointImpl live = null;
    ThreadIterator iterator;
    Vector records = new Vector();
    boolean userDiscardedData = false;
    List debugOffsets = new Vector();

    TraceThread(TraceContext traceContext, long l, long l2, String string) {
        this.context = traceContext;
        this.threadName = string;
        this.threadID = l;
        this.nativeThreadID = l2;
        this.threadIdentifier = l;
        this.stream = traceContext.createByteStream();
    }

    public Iterator getIterator() {
        if (this.iterator == null) {
            this.iterator = new ThreadIterator(this);
        }
        return this.iterator;
    }

    private synchronized TracePointImpl getNextRegularTracepoint() throws MissingDataException {
        long l = 0L;
        TracePointImpl tracePointImpl = null;
        try {
            if (this.stream != null) {
                tracePointImpl = new TracePointImpl(this.context, this.stream, this);
                if (this.context.debugLevel > 0) {
                    tracePointImpl.debugInfo = this.debugOffsets.size() > 0 ? (TracePointDebugInfo)this.debugOffsets.remove(0) : new TracePointDebugInfo(-1, -1);
                }
            }
            if (tracePointImpl == null) {
                return null;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            TraceRecord traceRecord = null;
            if (this.records.isEmpty()) {
                return null;
            }
            traceRecord = (TraceRecord)this.records.firstElement();
            this.records.remove(traceRecord);
            traceRecord.appendToStream(this.stream, this.threadRecordCount == 0L);
            ++this.threadRecordCount;
            if (this.context.debugLevel > 0) {
                Collections.reverse(traceRecord.debugOffsets);
                for (Integer n : traceRecord.debugOffsets) {
                    this.debugOffsets.add(new TracePointDebugInfo((int)this.context.totalRecords - 1, n));
                }
            }
            this.newestWrapTime = traceRecord.wrapTime;
            return this.getNextRegularTracepoint();
        }
        if (tracePointImpl.isInvalid()) {
            this.context.warning(this, "suppressing invalid tracepoint for thread " + this.threadIdentifier);
        } else if (tracePointImpl.isNormalTracepoint()) {
            tracePointImpl.time_merged = this.timerUpperWord.or(BigInteger.valueOf(tracePointImpl.time_lowerWord));
            return tracePointImpl;
        }
        long l2 = tracePointImpl.getLostRecordCount();
        if (l2 != 0L) {
            long l3 = 0L;
            if (l2 > 0L) {
                this.threadLostRecordCount += l2;
                l3 = l2 * (long)this.context.getRecordSize();
                this.context.debug(this, 2, "Tracepoint says we lost " + l2 + " records (total for thread: " + this.threadLostRecordCount + ")");
            } else if (l2 == -1L) {
                this.context.debug(this, 2, "Tracepoint probably injected for user discarded data of unknown size");
            } else if (l2 < 0L) {
                this.context.error(this, "lost bytes count is negative - lost " + l2 + " records of " + this.context.getRecordSize() + " bytes each");
                l3 = Long.MAX_VALUE;
            }
            throw new MissingDataException(this, l3);
        }
        l = tracePointImpl.getNewTimerUpperWord();
        if (l != 0L) {
            BigInteger bigInteger = this.timerUpperWord;
            this.timerUpperWord = BigInteger.valueOf(l).shiftLeft(32);
        }
        return this.getNextRegularTracepoint();
    }

    protected synchronized void addRecord(TraceRecord traceRecord) throws IllegalArgumentException {
        boolean bl = true;
        if (this.userDiscardedData) {
            traceRecord.userDiscardedData = true;
            this.userDiscardedData = false;
        }
        this.records.add(traceRecord);
    }

    synchronized void userDiscardedData() {
        this.userDiscardedData = true;
    }

    public int compareTo(Object object) {
        TraceThread traceThread = (TraceThread)object;
        if (this.next != null && traceThread.next != null) {
            return this.next.time_merged.compareTo(traceThread.next.time_merged);
        }
        if (this.next == null && traceThread.next == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return -1;
    }

    void refresh() {
        if (this.next == null) {
            this.context.sorted = false;
            long l = 0L;
            MissingDataException missingDataException = null;
            while (true) {
                try {
                    this.next = this.getNextRegularTracepoint();
                }
                catch (MissingDataException missingDataException2) {
                    l += missingDataException2.getMissingBytes();
                    missingDataException = missingDataException2;
                    continue;
                }
                break;
            }
            if (missingDataException != null) {
                missingDataException.missingByteCount = l;
                ((ThreadIterator)this.getIterator()).lostBytes = missingDataException;
            }
        }
    }

    public boolean equals(Long l) {
        return this.threadIdentifier.equals(l);
    }

    public String toString() {
        return ("[" + Long.toHexString(this.threadIdentifier) + "] " + this.threadName).intern();
    }

    public long getThreadID() {
        return this.threadID;
    }

    public long getNativeThreadID() {
        return this.nativeThreadID;
    }

    public String getThreadName() {
        return this.threadName;
    }

    class ThreadIterator
    implements Iterator {
        MissingDataException lostBytes;
        TraceThread thread;

        private ThreadIterator(TraceThread traceThread2) {
            this.thread = traceThread2;
        }

        @Override
        public boolean hasNext() {
            TraceThread.this.refresh();
            return TraceThread.this.next != null;
        }

        public Object next() throws MissingDataException {
            MissingDataException missingDataException = this.lostBytes;
            if (this.lostBytes != null) {
                this.lostBytes = null;
                throw missingDataException;
            }
            TraceThread.this.live = TraceThread.this.next;
            TraceThread.this.next = null;
            TraceThread.this.refresh();
            if (TraceThread.this.live != null && TraceThread.this.live.tracepointID == 262 && TraceThread.this.live.componentName.equals("dg")) {
                TraceThread.this.context.debug(this, 2, "End of data for thread " + TraceThread.this.threadIdentifier);
                if (TraceThread.this.next == null) {
                    TraceThread.this.stream = null;
                }
                TraceThread.this.context.threadTerminated(this.thread, TraceThread.this.next != null);
            }
            return TraceThread.this.live;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Tracepoints are removed as they are returned by the call to next()");
        }
    }
}

