/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class Symbol {
    String symbolName;
    long symbolStart;
    long symbolEnd;
    int symbolType;
    int symbolBinding;
    protected static HashMap knownSymbolsByName;
    protected static TreeMap symbolTree;
    static final int STB_UNKNOWN = -1;
    static final int STB_LOCAL = 0;
    static final int STB_GLOBAL = 1;
    static final int STB_WEAK = 2;
    static final int STT_NOTYPE = 0;
    static final int STT_OBJECT = 1;
    static final int STT_FUNC = 2;
    static final int STT_SECTION = 3;
    static final int STT_FILE = 4;
    static final int STT_COMMON = 5;
    static final int STT_TLS = 6;
    static final int STT_LOOS = 10;
    static final int STT_HIOS = 12;
    static final int STT_LOPROC = 13;
    static final int STT_HIPROC = 15;

    public Symbol(String string, long l, int n, int n2, int n3) {
        Object v;
        if (null == knownSymbolsByName) {
            knownSymbolsByName = new HashMap();
        }
        if ((v = knownSymbolsByName.get(string)) == null) {
            this.symbolName = string;
            this.symbolStart = l;
            this.symbolType = n2;
            this.symbolBinding = n3;
            this.symbolEnd = n != -1 ? l + (long)n : -1L;
            knownSymbolsByName.put(string, this);
            if (null == symbolTree) {
                SymbolComparator symbolComparator = new SymbolComparator();
                symbolTree = new TreeMap(symbolComparator);
            }
            symbolTree.put(l, this);
        }
    }

    public static Symbol getSymbol(String string) {
        Symbol symbol = null;
        symbol = (Symbol)knownSymbolsByName.get(string);
        return symbol;
    }

    public static String getSymbolForAddress(long l) {
        String string = null;
        SortedMap sortedMap = symbolTree.headMap(l);
        if (sortedMap != null && !sortedMap.isEmpty()) {
            Symbol symbol = (Symbol)symbolTree.get(sortedMap.lastKey());
            if (symbol.symbolEnd != -1L && l <= symbol.symbolEnd && l > symbol.symbolStart) {
                long l2 = l - symbol.symbolStart;
                string = symbol.symbolName + "+0x" + Long.toHexString(l2);
            }
        }
        return string;
    }

    public long getSymbolEnd() {
        return this.symbolEnd;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public long getSymbolStart() {
        return this.symbolStart;
    }

    public static Iterator getSymbolsIterator() {
        return symbolTree.keySet().iterator();
    }

    public static Symbol getSymbolUsingValue(Long l) {
        Symbol symbol = (Symbol)symbolTree.get(l);
        return symbol;
    }

    static final class SymbolComparator
    implements Comparator {
        SymbolComparator() {
        }

        public int compare(Object object, Object object2) {
            long l = 0L;
            long l2 = 0L;
            if (object instanceof Symbol) {
                Symbol symbol = (Symbol)object;
                Symbol symbol2 = (Symbol)object2;
                l = symbol.symbolStart;
                l2 = symbol2.symbolStart;
            } else {
                l = (Long)object;
                l2 = (Long)object2;
            }
            if (l >= 0L && l2 >= 0L) {
                if (l == l2) {
                    return 0;
                }
                if (l < l2) {
                    return -1;
                }
                return 1;
            }
            if (l < 0L && l2 < 0L) {
                if (l == l2) {
                    return 0;
                }
                if (l < l2) {
                    return 1;
                }
                return -1;
            }
            if (l < 0L && l2 >= 0L) {
                return 1;
            }
            return -1;
        }
    }
}

