/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class JavaAbstractClass
implements JavaClass {
    protected ImagePointer _classPointer;
    protected JavaRuntime _javaVM;
    private int _modifiers;
    private Vector _interfaceNames = new Vector();
    private long _classLoaderID;
    private ImagePointer _objectID;
    private int _flagOffset;
    private int _hashcodeSlot;
    private static final String PROTECTION_DOMAIN_FIELD_NAME = "protectionDomain";
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static DomainSearchOrder pdSearchOrder = DomainSearchOrder.UNDEFINED;

    protected JavaAbstractClass(JavaRuntime javaRuntime, ImagePointer imagePointer, int n, long l, ImagePointer imagePointer2, int n2, int n3) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("Java class pointer must be non-null");
        }
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a class must not be null");
        }
        this._javaVM = javaRuntime;
        this._classPointer = imagePointer;
        this._modifiers = n;
        this._classLoaderID = l;
        this._objectID = imagePointer2;
        this._flagOffset = n2;
        this._hashcodeSlot = n3;
    }

    @Override
    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this._javaVM.getClassLoaderForID(this._classLoaderID);
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        ImagePointer imagePointer = this._objectID == null ? this._classPointer : this._objectID;
        try {
            return this._javaVM.getObjectAtAddress(imagePointer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CorruptDataException(new CorruptData(illegalArgumentException.getMessage(), imagePointer));
        }
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        int n = this._modifiers;
        n = this.isArray() ? (n &= 0x417) : (n &= 0x761F);
        return n;
    }

    @Override
    public ImagePointer getID() {
        return this._classPointer;
    }

    @Override
    public Iterator getInterfaces() {
        return this._interfaceNames.iterator();
    }

    public void addInterfaceName(String string) {
        this._interfaceNames.add(string);
    }

    public abstract int getInstanceSize(JavaObject var1);

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaAbstractClass) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)object;
            bl = this.getClass().equals(javaAbstractClass.getClass()) && this._javaVM.equals(javaAbstractClass._javaVM) && this._classPointer.equals(javaAbstractClass._classPointer);
        }
        return bl;
    }

    public int getHashcodeSlotSize() {
        return this._hashcodeSlot;
    }

    @Override
    public int hashCode() {
        return this._javaVM.hashCode() ^ this._classPointer.hashCode();
    }

    public int readFlagsFromInstance(JavaObject javaObject) throws MemoryAccessException, CorruptDataException {
        try {
            com.ibm.dtfj.java.j9.JavaHeap javaHeap;
            JavaHeap javaHeap2 = javaObject.getHeap();
            if (javaHeap2 != null && !(javaHeap2 instanceof com.ibm.dtfj.image.CorruptData) && (javaHeap = (com.ibm.dtfj.java.j9.JavaHeap)javaHeap2).isSWH()) {
                return (int)(javaObject.getID().getPointerAt(this._flagOffset).getAddress() & 0xFFL);
            }
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        return javaObject.getID().getIntAt(this._flagOffset);
    }

    protected void addClassLoaderReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaObject javaObject;
            JavaClassLoader javaClassLoader = this.getClassLoader();
            if (null != javaClassLoader && null != (javaObject = javaClassLoader.getObject())) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, "Classloader", 4, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }

    protected void addSuperclassReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaClass javaClass = this.getSuperclass();
            if (null != javaClass) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaClass, "Superclass", 10, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }

    protected void addClassObjectReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaObject javaObject = this.getObject();
            if (null != javaObject) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, "Class object", 12, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }

    private JavaField getProtectionDomainField(JavaClass javaClass) throws CorruptDataException {
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            JavaField javaField;
            Object e = iterator.next();
            if (!(e instanceof JavaField) || !(javaField = (JavaField)e).getName().equals(PROTECTION_DOMAIN_FIELD_NAME)) continue;
            return javaField;
        }
        return null;
    }

    @Override
    public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
        Object object;
        JavaField javaField = null;
        switch (pdSearchOrder) {
            case UNDEFINED: {
                javaField = this.getProtectionDomainField(this);
                if (javaField == null) {
                    javaField = this.getProtectionDomainField(this.getObject().getJavaClass());
                    if (javaField == null) break;
                    pdSearchOrder = DomainSearchOrder.JAVA_LANG_FIRST;
                    break;
                }
                pdSearchOrder = DomainSearchOrder.J9CLASS_FIRST;
                break;
            }
            case J9CLASS_FIRST: {
                javaField = this.getProtectionDomainField(this);
                if (javaField != null || (javaField = this.getProtectionDomainField(this.getObject().getJavaClass())) == null) break;
                pdSearchOrder = DomainSearchOrder.JAVA_LANG_FIRST;
                break;
            }
            case JAVA_LANG_FIRST: {
                javaField = this.getProtectionDomainField(this.getObject().getJavaClass());
                if (javaField != null || (javaField = this.getProtectionDomainField(this)) == null) break;
                pdSearchOrder = DomainSearchOrder.J9CLASS_FIRST;
            }
        }
        if (javaField == null) {
            throw new DataUnavailable("The protection domain is not available");
        }
        try {
            object = javaField.get(this.getObject());
        }
        catch (MemoryAccessException memoryAccessException) {
            if (memoryAccessException.getPointer() == null) {
                CorruptData corruptData = new CorruptData("Invalid memory access : " + memoryAccessException.getMessage(), this._classPointer);
                throw new CorruptDataException(corruptData);
            }
            CorruptData corruptData = new CorruptData("Invalid memory access : " + memoryAccessException.getPointer().toString(), this._classPointer);
            throw new CorruptDataException(corruptData);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof JavaObject) {
            return (JavaObject)object;
        }
        CorruptData corruptData = new CorruptData("Unable to get protection domain", this._classPointer);
        throw new CorruptDataException(corruptData);
    }

    private static enum DomainSearchOrder {
        UNDEFINED,
        J9CLASS_FIRST,
        JAVA_LANG_FIRST;

    }
}

