/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.ImageSourceType;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedImageSource {
    private static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");
    private final String name;
    private String path;
    private int refcount = 0;
    private File archive = null;
    private File extractedTo = null;
    private ManagedImageSource metadata = null;
    private final ImageSourceType type;
    private final UUID uuid = UUID.randomUUID();

    public ManagedImageSource(String string, ImageSourceType imageSourceType) {
        this.name = string;
        this.type = imageSourceType;
    }

    public ImageSourceType getType() {
        return this.type;
    }

    public boolean hasMetaData() {
        return this.metadata != null;
    }

    public ManagedImageSource getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ManagedImageSource managedImageSource) {
        this.metadata = managedImageSource;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public boolean isCompressed() {
        return this.extractedTo == null;
    }

    public String getName() {
        return this.name;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File file) {
        this.archive = file;
    }

    public File getExtractedTo() {
        return this.extractedTo;
    }

    public void setExtractedTo(File file) {
        this.extractedTo = file;
    }

    public int getRefCount() {
        return this.refcount;
    }

    public void incRefCount() {
        ++this.refcount;
    }

    public void decRefCount() {
        if (this.refcount > 0) {
            --this.refcount;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ManagedImageSource)) {
            return false;
        }
        ManagedImageSource managedImageSource = (ManagedImageSource)object;
        return this.toURI().equals(managedImageSource.toURI());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getPathToExtractedFile() {
        return this.extractedTo.getAbsolutePath();
    }

    public URI getURIOfExtractedFile() {
        if (this.extractedTo != null) {
            return this.extractedTo.toURI();
        }
        return null;
    }

    public URI toURI() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.archive != null) {
                stringBuilder.append(this.archive.toURI().toString());
                stringBuilder.append("#");
                if (this.path != null) {
                    stringBuilder.append(this.path);
                    stringBuilder.append("/");
                }
                stringBuilder.append(this.name);
                String string = stringBuilder.toString();
                String string2 = string.replace('\\', '/').replace(" ", "%20");
                return new URI(string2);
            }
            if (this.path != null) {
                File file = null;
                file = this.path.toLowerCase().endsWith(this.name.toLowerCase()) ? new File(this.path) : new File(this.path, this.name);
                return file.toURI();
            }
        }
        catch (Exception exception) {
            String string = "Error creating URI for managed image source : " + this.name;
            logger.fine(string);
            logger.log(Level.FINEST, string, exception);
        }
        try {
            return new URI("file://" + this.uuid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.toURI().toString());
        stringBuilder.append(" (");
        stringBuilder.append(this.type.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

