/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.Dump;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.jvm.j9.dump.extract.JExtractFatalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private String _dumpName = null;
    private File _virtualRootDirectory = null;
    private boolean _verbose;
    private static boolean _throwExceptions;
    private ICoreFileReader _dump = null;
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private DummyBuilder _builder;
    private static int JEXTRACT_SUCCESS;
    private static int JEXTRACT_SYNTAX_ERROR;
    private static int JEXTRACT_FILE_ERROR;
    private static int JEXTRACT_NOJVM_ERROR;
    private static int JEXTRACT_ADDRESS_ERROR;
    private static int JEXTRACT_VERSION_ERROR;
    private static int JEXTRACT_INTERNAL_ERROR;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        if (stringArray.length == 0) {
            Main.usageMessage(null, JEXTRACT_SUCCESS);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl && stringArray[i].startsWith("-")) {
                File file2;
                if ("--".equals(stringArray[i])) {
                    bl = true;
                    continue;
                }
                if ("-interactive".equals(stringArray[i])) {
                    bl2 = true;
                    continue;
                }
                if ("-help".equals(stringArray[i])) {
                    Main.usageMessage(null, JEXTRACT_SUCCESS);
                    continue;
                }
                if ("-f".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -f option specified with no filename following");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead(), "File specified using -f option (\"" + stringArray[i] + "\") not found.");
                    System.setProperty("com.ibm.dtfj.corereaders.executable", stringArray[i]);
                    continue;
                }
                if ("-p".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead() && file2.isDirectory(), "Virtual directory specified using -p option (\"" + stringArray[i] + "\") does not exist as a readable directory.");
                    file = new File(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-e")) {
                    bl4 = true;
                    continue;
                }
                Main.usageMessage("Unrecognized option: " + stringArray[i], JEXTRACT_SYNTAX_ERROR);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            Main.usageMessage("Too many file arguments: " + stringArray[i], JEXTRACT_SYNTAX_ERROR);
        }
        Main.ensure(null != string, "No dump file specified");
        Main main = new Main(string, file, bl3, bl4);
        if (bl2) {
            main.runInteractive();
        } else {
            if (bl5) {
                main.runZip(string2);
            }
            Main.report("jextract complete.");
        }
    }

    private static void ensure(boolean bl, String string) {
        if (!bl) {
            Main.usageMessage(string, JEXTRACT_SYNTAX_ERROR);
        }
    }

    private static void usageMessage(String string, int n) {
        Main.report("Usage: jextract dump_name [output_filename] [options]");
        Main.report(" output filename defaults to dump_name.zip");
        Main.report(" options:");
        Main.report("   -f executable_name override executable name");
        Main.report("   -help              print this usage message");
        Main.report("   -v                 enable verbose output");
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private static void errorMessage(String string, int n) {
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private static void errorMessage(String string, int n, Throwable throwable) {
        throwable.printStackTrace();
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private Main(String string, File file, boolean bl, boolean bl2) {
        this._dumpName = string;
        this._virtualRootDirectory = file;
        this._verbose = bl;
        _throwExceptions = bl2;
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException securityException) {
            Main.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Main.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (Exception exception) {
            Main.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JEXTRACT_INTERNAL_ERROR, exception);
        }
        Main.report("Loading dump file...");
        File file2 = new File(string);
        ClosingFileReader closingFileReader = null;
        try {
            closingFileReader = new ClosingFileReader(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!file2.exists()) {
                Main.errorMessage("Error. Could not find dump file: " + string, JEXTRACT_FILE_ERROR);
            } else if (!file2.canRead()) {
                Main.errorMessage("Error. Unable to read dump file (check permission): " + string, JEXTRACT_FILE_ERROR);
            } else {
                Main.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + string, JEXTRACT_FILE_ERROR, fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Main.errorMessage(iOException.getMessage(), JEXTRACT_FILE_ERROR);
        }
        try {
            this._dump = DumpFactory.createDumpForCore(closingFileReader, this._verbose);
        }
        catch (Exception exception) {
            Main.errorMessage("Error. Unexpected Exception occurred opening: " + string, JEXTRACT_FILE_ERROR, exception);
        }
        if (null == this._dump) {
            Main.errorMessage("Error. Dump type not recognised, file: " + string, JEXTRACT_FILE_ERROR);
        }
        if (this._dump.isTruncated()) {
            Main.report("Warning: dump file is truncated. Extracted information may be incomplete.");
        }
        this._builder = new DummyBuilder(this._virtualRootDirectory);
        this._dump.extract(this._builder);
        if (this._dump instanceof NewElfDump && !this._builder.isExecutableAvailable()) {
            long l = 0L;
            try {
                l = this.getEnvironmentPointer(this._dump.getAddressSpace());
            }
            catch (Throwable throwable) {
                Main.errorMessage("Error. Unable to locate executable for " + string, JEXTRACT_INTERNAL_ERROR, throwable);
            }
            if (l != 0L) {
                this._builder = new DummyBuilder(this._virtualRootDirectory, l);
                try {
                    this._dump = DumpFactory.createDumpForCore(closingFileReader, this._verbose);
                }
                catch (IOException iOException) {
                    Main.errorMessage("Error. Unexpected Exception occurred opening: " + string + " for the second time", JEXTRACT_FILE_ERROR, iOException);
                }
                this._dump.extract(this._builder);
            }
        }
        Main.report("Read memory image from " + this._dumpName);
    }

    private void runZip(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this._dumpName);
        Object object = this._dump.getAdditionalFileNames();
        while (object.hasNext()) {
            arrayList.add((String)object.next());
        }
        try {
            String string2;
            String string3;
            String string4;
            object = System.getProperty("java.home") + File.separator + "lib" + File.separator;
            String string5 = (String)object + "TraceFormat.dat";
            if (new File(string5).exists()) {
                arrayList.add(string5);
            }
            if (new File(string4 = (String)object + "J9TraceFormat.dat").exists()) {
                arrayList.add(string4);
            }
            if (new File(string3 = (String)object + "OMRTraceFormat.dat").exists()) {
                arrayList.add(string3);
            }
            if ((string2 = System.getProperty("os.name")) != null && string2.equalsIgnoreCase("AIX")) {
                arrayList.add("libdbx_j9.so");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Main.createZipFromFileNames(null != string ? string : this._dumpName.concat(".zip"), arrayList.iterator(), this._builder);
        }
        catch (Exception exception) {
            Main.errorMessage(exception.getMessage(), JEXTRACT_INTERNAL_ERROR, exception);
        }
    }

    private void runInteractive() {
        Main.report("Jextract interactive mode.");
        Main.report("Type '!j9help' for help.");
        Main.report("Type 'quit' to quit.");
        Main.report("(Commands must be prefixed with '!')");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        IAbstractAddressSpace iAbstractAddressSpace = this._dump.getAddressSpace();
        if (iAbstractAddressSpace == null) {
            Main.report("Error. Address space not found in dump: " + this._dumpName + ". Dump is truncated, corrupted or does not contain a supported JVM.");
            return;
        }
        block4: while (true) {
            try {
                while (true) {
                    Main.report("> ");
                    String string = bufferedReader.readLine().trim();
                    if ("quit".equalsIgnoreCase(string) || "q".equalsIgnoreCase(string)) break block4;
                    try {
                        this.doCommand(iAbstractAddressSpace, string);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        Main.report(throwable.getMessage());
                        Main.report("Failure detected during command execution, see previous message(s).");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Main.report("Error reading input.");
                break;
            }
        }
    }

    private static void report(String string) {
        System.err.println(string);
    }

    private static void createZipFromFileNames(String string, Iterator iterator, Builder builder) throws Exception {
        Main.report("Creating archive file: " + string);
        try {
            HashSet<String> hashSet = new HashSet<String>();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            byte[] byArray = new byte[32768];
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    ClosingFileReader closingFileReader = builder.openFile(string2);
                    boolean bl = closingFileReader.isMVSFile();
                    String string3 = closingFileReader.getAbsolutePath();
                    if (string3.equals(new File(string2).getAbsolutePath()) || bl) {
                        Main.report("Adding \"" + string2 + "\"");
                    } else {
                        Main.report("Adding \"" + string2 + "\" (found at \"" + string3 + "\")");
                    }
                    if (bl) {
                        zipOutputStream.putNextEntry(new ZipEntry(string2));
                        hashSet.add(string2);
                        Main.copy(closingFileReader, (OutputStream)zipOutputStream, byArray);
                        continue;
                    }
                    if (hashSet.contains(string3)) continue;
                    InputStream inputStream = closingFileReader.streamFromFile();
                    ZipEntry zipEntry = new ZipEntry(string3);
                    hashSet.add(string3);
                    zipEntry.setTime(new File(string3).lastModified());
                    zipOutputStream.putNextEntry(zipEntry);
                    Main.copy(inputStream, (OutputStream)zipOutputStream, byArray);
                    inputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Main.report("Warning:  Could not find file \"" + string2 + "\" for inclusion in archive");
                }
                catch (IOException iOException) {
                    throw new Exception("Failure adding file " + string2 + " to archive", iOException);
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                throw new Exception("Failure closing archive file (" + string + ") : " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Could not find archive file to output to: " + fileNotFoundException.getMessage());
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    private static void copy(ClosingFileReader closingFileReader, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = closingFileReader.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = closingFileReader.read(byArray);
        }
    }

    private native long getEnvironmentPointer(IAbstractAddressSpace var1) throws Exception;

    private native void doCommand(IAbstractAddressSpace var1, String var2) throws Exception;

    static {
        JEXTRACT_SUCCESS = 0;
        JEXTRACT_SYNTAX_ERROR = 1;
        JEXTRACT_FILE_ERROR = 2;
        JEXTRACT_NOJVM_ERROR = 3;
        JEXTRACT_ADDRESS_ERROR = 4;
        JEXTRACT_VERSION_ERROR = 5;
        JEXTRACT_INTERNAL_ERROR = 6;
    }

    private static class DummyBuilder
    implements Builder {
        private File _virtualRootDirectory = null;
        private Vector _successfulSearchPaths = new Vector();
        private boolean _executableAvailable = true;
        private final long _environmentPointer;

        public DummyBuilder(File file) {
            this(file, 0L);
        }

        public DummyBuilder(File file, long l) {
            this._virtualRootDirectory = file;
            String string = System.getProperty("java.home") + File.separator + "bin";
            File file2 = new File(string);
            this._successfulSearchPaths.add(file2);
            this._environmentPointer = l;
        }

        @Override
        public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
            return new Object();
        }

        public Object buildAddressSpace(String string, Dump dump, int n) {
            return new Object();
        }

        @Override
        public Object buildRegister(String string, Number number) {
            return new Register(string, number.longValue());
        }

        @Override
        public Object buildStackSection(Object object, long l, long l2) {
            return new Object();
        }

        @Override
        public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
            return new Object();
        }

        @Override
        public Object buildModuleSection(Object object, String string, long l, long l2) {
            return new Object();
        }

        @Override
        public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2, long l) {
            return new Object();
        }

        @Override
        public long getEnvironmentAddress() {
            return this._environmentPointer;
        }

        @Override
        public long getValueOfNamedRegister(List list, String string) {
            for (Register register : list) {
                if (!string.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        @Override
        public Object buildStackFrame(Object object, long l, long l2) {
            return new Object();
        }

        @Override
        public ClosingFileReader openFile(String string) throws IOException {
            File file;
            Object object;
            Object object2;
            File file2 = new File(string);
            if (null != this._virtualRootDirectory && file2.isAbsolute()) {
                file2 = this.sysFileRelative(this._virtualRootDirectory, file2);
            } else if (!file2.isAbsolute() && !file2.exists()) {
                object2 = this._successfulSearchPaths.iterator();
                object = file2.getName();
                while (object2.hasNext()) {
                    file = (File)object2.next();
                    File file3 = new File(file, (String)object);
                    if (!file3.exists()) continue;
                    ClosingFileReader closingFileReader = new ClosingFileReader(file3);
                    return closingFileReader;
                }
            }
            if (file2.exists()) {
                object2 = new ClosingFileReader(file2);
                object = file2.getParentFile();
                if (null != object && !this._successfulSearchPaths.contains(file = ((File)object).getAbsoluteFile())) {
                    this._successfulSearchPaths.add(file);
                }
                return object2;
            }
            object2 = new ClosingFileReader(file2);
            return object2;
        }

        private File sysFileRelative(File file, File file2) {
            File file3 = file2;
            while (null != file3.getParentFile()) {
                file3 = file3.getParentFile();
            }
            File file4 = file2;
            if (file2.isAbsolute()) {
                String string = file2.getAbsolutePath().substring(file3.getAbsolutePath().length());
                file4 = new File(file, string);
            }
            return file4;
        }

        @Override
        public Object buildSymbol(Object object, String string, long l) {
            return new Object();
        }

        @Override
        public void setExecutableUnavailable(String string) {
            this._executableAvailable = false;
        }

        public boolean isExecutableAvailable() {
            return this._executableAvailable;
        }

        @Override
        public Object buildAddressSpace(String string, int n) {
            return new Object();
        }

        @Override
        public void setOSType(String string) {
        }

        @Override
        public void setCPUType(String string) {
        }

        @Override
        public void setCPUSubType(String string) {
        }

        @Override
        public void setCreationTime(long l) {
        }

        @Override
        public Object buildCorruptData(Object object, String string, long l) {
            return new Object();
        }

        private static class Register {
            final String name;
            final long value;

            Register(String string, long l) {
                this.name = string;
                this.value = l;
            }
        }
    }
}

