/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.util.ArrayList;

public class ParsedCommand {
    private String command;
    private String[] arguments;

    public static ParsedCommand parse(String string) {
        String[] stringArray = ParsedCommand.separateAndReorganizeTokens(string);
        String string2 = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray2[i - 1] = stringArray[i];
        }
        return new ParsedCommand(string2, stringArray2);
    }

    public ParsedCommand(String string, String[] stringArray) {
        this.setCommand(string);
        this.setArguments(stringArray);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public String getCombinedCommandLine() {
        StringBuilder stringBuilder = new StringBuilder(this.getCommand());
        for (String string : this.arguments) {
            if (0 <= string.indexOf(" ") || 0 <= string.indexOf("\t")) {
                string = 0 <= string.indexOf("\"") ? "'" + string + "'" : "\"" + string + "\"";
            }
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    private static String[] separateAndReorganizeTokens(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if ('\"' == (c = string.charAt(n++)) || '\'' == c) {
                if (n < string.length() && c == string.charAt(n)) {
                    stringBuffer.append(c).append(c);
                    ++n;
                    continue;
                }
                char c2 = c;
                while (n < string.length() && (c = string.charAt(n++)) != c2) {
                    stringBuffer.append(c);
                }
                continue;
            }
            if (" \t\n\r\f".indexOf(c) >= 0) {
                if (stringBuffer.length() <= 0) continue;
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if ('|' == c) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                arrayList.add("|");
                continue;
            }
            if (n < n2 && '|' == string.charAt(n)) {
                stringBuffer.append(c);
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                arrayList.add("|");
                ++n;
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        ArrayList<String> arrayList2 = ParsedCommand.reorganize(arrayList);
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static ArrayList<String> reorganize(ArrayList<String> arrayList) {
        return ParsedCommand.reorganize(arrayList, 0, false);
    }

    private static ArrayList<String> reorganize(ArrayList<String> arrayList, int n, boolean bl) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = n; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (string.equals("|") || string.equals(">") || string.equals(">>")) {
                ArrayList<String> arrayList3 = ParsedCommand.reorganize(arrayList, i + 1, string.equals("|"));
                bl = false;
                for (int j = arrayList3.size() - 1; j >= 0; --j) {
                    arrayList2.add(0, arrayList3.get(j));
                }
                if (string.equals("|")) break;
                arrayList2.add(0, string);
                break;
            }
            if (bl) {
                if (!ToolsRegistry.isPipeLineEnabled(string, null)) {
                    arrayList2.add("run");
                    if (!string.equalsIgnoreCase("-head") && !string.equalsIgnoreCase("-tail")) {
                        arrayList2.add("-head");
                    }
                }
                bl = false;
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }
}

