/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.IStringModifier;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import java.io.PrintStream;

public class CharsToTool
extends Tool
implements IPipe {
    private static final String COMMAND = "charsTo";
    private static final String ARGUMENT_DESCRIPTION = "[options] <pattern>";
    private static final String HELP_DESCRIPTION = "To be used after a pipeline to keep the characters from a line until a specific pattern is found.";
    private static final String USAGE = "charsTo\t[options] <pattern>\tTo be used after a pipeline to keep the characters from a line until a specific pattern is found.\n     Options :\n          -include : to include the matched pattern in the resulting line. If this option is not used, the matched pattern will be excluded from the resulting line.\n          -keep : to keep the lines which does not match the pattern. If this option is not used, the line without a match will be excluded.\n          -i, -ignoreCase : to treat the pattern case-insensitive.";

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase(COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        Arguments arguments = CharsToTool.processArguments(stringArray);
        if (arguments == null) {
            printStream.println(USAGE);
            return;
        }
        StringModifier stringModifier = new StringModifier(arguments);
        try (PrintStream printStream2 = null;){
            printStream2 = new PrintStream(new OutputStreamModifier(printStream, stringModifier));
            ToolsRegistry.process(arguments.nextCommand, arguments.nextCommandArgs, printStream2);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private static Arguments processArguments(String[] stringArray) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-include")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-i")) {
                bl3 = true;
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-keep")) break;
            bl2 = true;
        }
        if (n >= stringArray.length) {
            return null;
        }
        String string = stringArray[n];
        if (++n >= stringArray.length) {
            return null;
        }
        String string2 = stringArray[n];
        String[] stringArray2 = new String[stringArray.length - ++n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray.length - n);
        return new Arguments(string, bl, bl2, bl3, string2, stringArray2);
    }

    private static final class StringModifier
    implements IStringModifier {
        private final Arguments attr;

        StringModifier(Arguments arguments) {
            this.attr = arguments;
        }

        @Override
        public String modify(String string) {
            int n = -1;
            n = this.attr.ignoreCase ? string.toLowerCase().indexOf(this.attr.searchToken) : string.indexOf(this.attr.searchToken);
            if (n < 0) {
                if (this.attr.keepMismatchedLines) {
                    return string;
                }
                return "";
            }
            if (this.attr.includeToken) {
                return string.substring(0, n + this.attr.searchToken.length()) + "\n";
            }
            return string.substring(0, n) + "\n";
        }
    }

    private static final class Arguments {
        final String searchToken;
        final boolean includeToken;
        final boolean keepMismatchedLines;
        final boolean ignoreCase;
        final String nextCommand;
        final String[] nextCommandArgs;

        Arguments(String string, boolean bl, boolean bl2, boolean bl3, String string2, String[] stringArray) {
            this.searchToken = bl3 ? string.toLowerCase() : string;
            this.includeToken = bl;
            this.keepMismatchedLines = bl2;
            this.ignoreCase = bl3;
            this.nextCommand = string2;
            this.nextCommandArgs = stringArray;
        }
    }
}

