/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.lang.management.ProcessorMXBean;
import com.ibm.oti.util.Msg;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class ProcessorMXBeanImpl
implements ProcessorMXBean {
    static final int PHYSICAL = 1;
    static final int ONLINE = 2;
    static final int BOUND = 3;
    static final int TARGET = 4;
    private static final ProcessorMXBean instance = new ProcessorMXBeanImpl();

    public static ProcessorMXBean getInstance() {
        return instance;
    }

    private ProcessorMXBeanImpl() {
    }

    @Override
    public ObjectName getObjectName() {
        try {
            ObjectName objectName = new ObjectName("com.ibm.lang.management:type=Processor");
            return objectName;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    native int getNumberCPUsImpl(int var1);

    @Override
    public int getNumberPhysicalCPUs() {
        return this.getNumberCPUsImpl(1);
    }

    @Override
    public int getNumberOnlineCPUs() {
        return this.getNumberCPUsImpl(2);
    }

    @Override
    public int getNumberBoundCPUs() {
        return this.getNumberCPUsImpl(3);
    }

    @Override
    public int getNumberTargetCPUs() {
        return this.getNumberCPUsImpl(4);
    }

    private native void setNumberActiveCPUsImpl(int var1);

    @Override
    public void setNumberActiveCPUs(int n) throws IllegalArgumentException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (0 > n) {
            throw new IllegalArgumentException(Msg.getString("K0567"));
        }
        this.setNumberActiveCPUsImpl(n);
    }
}

