/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.VM;
import java.io.FilePermission;
import java.lang.reflect.Method;

public final class BootstrapClassLoader
extends AbstractClassLoader {
    private static BootstrapClassLoader singleton;
    private static Method appendToClassPathForInstrumentationMethod;
    private static boolean initAppendMethod;

    private BootstrapClassLoader() {
        int n = VM.getClassPathCount();
        this.types = new int[n];
        this.cache = new Object[n];
        this.parsedPath = new String[n];
        VM.initializeClassLoader(this, VM.J9_CLASSLOADER_TYPE_BOOT, false);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = VM.getVMLangAccess().findClassOrNullHelper(string, this);
        return clazz;
    }

    public static ClassLoader singleton() {
        if (singleton != null) {
            throw new SecurityException(Msg.getString("K0084"));
        }
        singleton = new BootstrapClassLoader();
        return singleton;
    }

    @Override
    protected Package getPackage(String string) {
        return VM.getVMLangAccess().getSystemPackage(string);
    }

    @Override
    protected Package[] getPackages() {
        return VM.getVMLangAccess().getSystemPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToClassPathForInstrumentation(String string) throws Throwable {
        Object object = cacheLock;
        synchronized (object) {
            int n = this.addJar(Util.getBytes(string));
            int[] nArray = new int[n];
            System.arraycopy((Object)this.types, 0, (Object)nArray, 0, n - 1);
            this.types = nArray;
            Object[] objectArray = new Object[n];
            System.arraycopy((Object)this.cache, 0, (Object)objectArray, 0, n - 1);
            this.cache = objectArray;
            String[] stringArray = new String[n];
            System.arraycopy((Object)this.parsedPath, 0, (Object)stringArray, 0, n - 1);
            this.parsedPath = stringArray;
            if (this.permissions != null) {
                FilePermission[] filePermissionArray = new FilePermission[n];
                System.arraycopy((Object)this.permissions, 0, (Object)filePermissionArray, 0, n - 1);
                this.permissions = filePermissionArray;
            }
            this.resourceCacheRef = null;
        }
    }

    private native int addJar(byte[] var1);

    static {
        appendToClassPathForInstrumentationMethod = null;
        initAppendMethod = true;
    }
}

