/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.buf.length) {
            this.flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy((Object)byArray, n, (Object)this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

