/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public final class Array {
    private Array() {
    }

    public static Object get(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == int[].class) {
            return ((int[])object)[n];
        }
        if (clazz == boolean[].class) {
            return ((boolean[])object)[n] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == float[].class) {
            return Float.valueOf(((float[])object)[n]);
        }
        if (clazz == char[].class) {
            return Character.valueOf(((char[])object)[n]);
        }
        if (clazz == double[].class) {
            return ((double[])object)[n];
        }
        if (clazz == long[].class) {
            return ((long[])object)[n];
        }
        if (clazz == short[].class) {
            return ((short[])object)[n];
        }
        if (clazz == byte[].class) {
            return new Byte(((byte[])object)[n]);
        }
        try {
            return ((Object[])object)[n];
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static boolean getBoolean(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((boolean[])object)[n];
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static byte getByte(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((byte[])object)[n];
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static char getChar(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((char[])object)[n];
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static double getDouble(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == double[].class) {
            return ((double[])object)[n];
        }
        return Array.getFloat(object, n);
    }

    public static float getFloat(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == float[].class) {
            return ((float[])object)[n];
        }
        return Array.getLong(object, n);
    }

    public static int getInt(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == int[].class) {
            return ((int[])object)[n];
        }
        if (clazz == char[].class) {
            return ((char[])object)[n];
        }
        return Array.getShort(object, n);
    }

    public static int getLength(Object object) throws IllegalArgumentException {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == int[].class) {
            return ((int[])object).length;
        }
        if (clazz == boolean[].class) {
            return ((boolean[])object).length;
        }
        if (clazz == float[].class) {
            return ((float[])object).length;
        }
        if (clazz == char[].class) {
            return ((char[])object).length;
        }
        if (clazz == double[].class) {
            return ((double[])object).length;
        }
        if (clazz == long[].class) {
            return ((long[])object).length;
        }
        if (clazz == short[].class) {
            return ((short[])object).length;
        }
        if (clazz == byte[].class) {
            return ((byte[])object).length;
        }
        try {
            return ((Object[])object).length;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static long getLong(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == long[].class) {
            return ((long[])object)[n];
        }
        return Array.getInt(object, n);
    }

    public static short getShort(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == short[].class) {
            return ((short[])object)[n];
        }
        return Array.getByte(object, n);
    }

    private static native Object multiNewArrayImpl(Class var0, int var1, int[] var2);

    private static native Object newArrayImpl(Class var0, int var1);

    public static Object newInstance(Class<?> clazz, int ... nArray) throws NegativeArraySizeException, IllegalArgumentException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        int n = nArray.length;
        if (n < 1 || n > 255 || clazz == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 0) {
                throw new NegativeArraySizeException();
            }
            nArray2[n - i - 1] = nArray[i];
        }
        return Array.multiNewArrayImpl(clazz, n, nArray2);
    }

    public static Object newInstance(Class<?> clazz, int n) throws NegativeArraySizeException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        return Array.newArrayImpl(clazz, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(Object object, int n, Object object2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null && clazz.isPrimitive()) {
            if (object2 == null) {
                throw new IllegalArgumentException();
            }
            Class<? extends Object> clazz2 = object2.getClass();
            if (clazz2 == Integer.class) {
                Array.setInt(object, n, (Integer)object2);
                return;
            } else if (clazz2 == Float.class) {
                Array.setFloat(object, n, ((Float)object2).floatValue());
                return;
            } else if (clazz2 == Double.class) {
                Array.setDouble(object, n, (Double)object2);
                return;
            } else if (clazz2 == Long.class) {
                Array.setLong(object, n, (Long)object2);
                return;
            } else if (clazz2 == Short.class) {
                Array.setShort(object, n, (Short)object2);
                return;
            } else if (clazz2 == Byte.class) {
                Array.setByte(object, n, (Byte)object2);
                return;
            } else if (clazz2 == Boolean.class) {
                Array.setBoolean(object, n, (Boolean)object2);
                return;
            } else {
                if (clazz2 != Character.class) throw new IllegalArgumentException();
                Array.setChar(object, n, ((Character)object2).charValue());
            }
            return;
        }
        try {
            ((Object[])object)[n] = object2;
            return;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException(arrayStoreException.getMessage());
        }
    }

    public static void setBoolean(Object object, int n, boolean bl) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            ((boolean[])object)[n] = bl;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static void setByte(Object object, int n, byte by) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == byte[].class) {
            ((byte[])object)[n] = by;
        } else {
            Array.setShort(object, n, by);
        }
    }

    public static void setChar(Object object, int n, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == char[].class) {
            ((char[])object)[n] = c;
        } else {
            Array.setInt(object, n, c);
        }
    }

    public static void setDouble(Object object, int n, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            ((double[])object)[n] = d;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.getMessage());
        }
    }

    public static void setFloat(Object object, int n, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == float[].class) {
            ((float[])object)[n] = f;
        } else {
            Array.setDouble(object, n, f);
        }
    }

    public static void setInt(Object object, int n, int n2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == int[].class) {
            ((int[])object)[n] = n2;
        } else {
            Array.setLong(object, n, n2);
        }
    }

    public static void setLong(Object object, int n, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == long[].class) {
            ((long[])object)[n] = l;
        } else {
            Array.setFloat(object, n, l);
        }
    }

    public static void setShort(Object object, int n, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object.getClass() == short[].class) {
            ((short[])object)[n] = s;
        } else {
            Array.setInt(object, n, s);
        }
    }
}

