/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.FileLock;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

public abstract class CommonDirectory {
    private static final String ATTACH_LOCK = "_attachlock";
    private static final String COM_IBM_TOOLS_ATTACH_DIRECTORY = "com.ibm.tools.attach.directory";
    private static final int COMMON_DIRECTORY_PERMISSIONS = 1023;
    private static final int COMMON_LOCK_FILE_PERMISSIONS = 438;
    private static final String MASTER_LOCKFILE = "_master";
    static final String MASTER_NOTIFIER = "_notifier";
    static final int SEMAPHORE_OKAY = 0;
    private static final String TRASH_PREFIX = ".trash_";
    private static final syncObject accessorMutex = new syncObject();
    private static FileLock attachLock;
    private static File commonDirFile;
    private static FileLock masterLock;
    private static String semaphoreId;
    private static int masterLockCount;
    private static final String systemTmpDir;
    public static final int J9PORT_INFO_SHSEM_OPENED_STALE = 103;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCommonDirFileObject(File file) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            commonDirFile = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCommonDirFileObject() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == commonDirFile) {
                CommonDirectory.initialize();
            }
            return commonDirFile;
        }
    }

    static String getCommonDirPath() {
        return CommonDirectory.getCommonDirFileObject().getAbsolutePath();
    }

    private static void initialize() {
        String string = VM.getVMLangAccess().internalGetProperties().getProperty(COM_IBM_TOOLS_ATTACH_DIRECTORY, new File(systemTmpDir, ".com_ibm_tools_attach").getPath());
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("IPC Directory=", string);
        }
        File file = new File(string);
        CommonDirectory.setCommonDirFileObject(file);
    }

    static void prepareCommonDirectory() throws IOException {
        File file = CommonDirectory.getCommonDirFileObject();
        if (file.exists()) {
            if (!file.canWrite()) {
                IPC.logMessage("could not write ", file.getAbsolutePath());
                throw new IOException(file.getAbsolutePath());
            }
            if (!file.isDirectory()) {
                if (!file.delete()) {
                    IPC.logMessage("could not delete ", file.getAbsolutePath());
                    throw new IOException(file.getAbsolutePath());
                }
                IPC.logMessage("deleted ", file.getAbsolutePath());
                IPC.mkdirWithPermissions(file.getAbsolutePath(), 1023);
                IPC.logMessage("After deletion of an existing file, created the common directory at ", file.getAbsolutePath());
            } else if (1 != IPC.loggingStatus) {
                IPC.logMessage("The common directory already exists at ", file.getAbsolutePath());
            }
        } else {
            IPC.mkdirWithPermissions(file.getAbsolutePath(), 1023);
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("Created the common directory at ", file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obtainMasterLock() throws IOException {
        FileLock fileLock = null;
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (1 == ++masterLockCount) {
                fileLock = CommonDirectory.getMasterLock();
            }
        }
        if (null != fileLock) {
            fileLock.lockFile(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tryObtainMasterLock() {
        boolean bl = true;
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (1 == ++masterLockCount) {
                try {
                    bl = CommonDirectory.getMasterLock().lockFile(false);
                    if (!bl) {
                        --masterLockCount;
                    }
                }
                catch (IOException iOException) {
                    bl = false;
                    IPC.logMessage("IOException in tryObtainMasterLock, masterLockCount=" + masterLockCount, iOException);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMasterLock() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (masterLockCount <= 0) {
                IPC.logMessage("releaseMasterLock: Illegal value for masterLockCount", masterLockCount);
                return;
            }
            if (Objects.nonNull(masterLock) && 0 == --masterLockCount) {
                masterLock.unlockFile();
                masterLock = null;
            }
        }
    }

    public static void obtainAttachLock() throws IOException {
        CommonDirectory.getAttachLock().lockFile(true);
    }

    public static void releaseAttachLock() {
        try {
            CommonDirectory.getAttachLock().unlockFile();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    static void createNotificationFile() throws IOException {
        File file = new File(CommonDirectory.getCommonDirFileObject(), MASTER_NOTIFIER);
        if (file.createNewFile()) {
            IPC.chmod(file.getAbsolutePath(), 438);
        }
    }

    static String openSemaphore() throws IOException {
        String string = MASTER_NOTIFIER;
        int n = IPC.openSemaphore(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), string, true);
        if (0 != n) {
            throw new IOException(Msg.getString("K0538", (Object)string, n));
        }
        return string;
    }

    static int reopenSemaphore() {
        int n = 0;
        IPC.logMessage("reopenSemaphore");
        CommonDirectory.closeSemaphore();
        n = IPC.openSemaphore(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), MASTER_NOTIFIER, true);
        return n;
    }

    static int waitSemaphore(String string) {
        int n = IPC.waitSemaphore();
        if (0 != n) {
            IPC.logMessage("waitSemaphore status != JNI_OK, ==", n);
        }
        return n;
    }

    public static int notifyVm(int n, boolean bl) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("notifyVm ", n, " targets");
        }
        return IPC.notifyVm(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), MASTER_NOTIFIER, n, bl);
    }

    public static int cancelNotify(int n, boolean bl) {
        return IPC.cancelNotify(CommonDirectory.getCommonDirPath(), MASTER_NOTIFIER, n, bl);
    }

    static void closeSemaphore() {
        IPC.closeSemaphore();
    }

    static void destroySemaphore() {
        IPC.destroySemaphore();
    }

    public static int countTargetDirectories() {
        File file = CommonDirectory.getCommonDirFileObject();
        if (!file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (string.startsWith(TRASH_PREFIX) || CommonDirectory.isCommonControlFile(string)) continue;
            ++n;
        }
        return n;
    }

    private static boolean isCommonControlFile(String string) {
        return ATTACH_LOCK.equalsIgnoreCase(string) || MASTER_LOCKFILE.equalsIgnoreCase(string) || MASTER_NOTIFIER.equalsIgnoreCase(string);
    }

    static void deleteStaleDirectories(String string) {
        long l = IPC.getUid();
        File[] fileArray = CommonDirectory.getCommonDirFileObject().listFiles(new DirectorySampler());
        if (null == fileArray) {
            return;
        }
        for (File file : fileArray) {
            long l2;
            if (AttachHandler.isAttachApiTerminated()) break;
            if (!CommonDirectory.isFileOwnedByUid(file, l)) continue;
            String string2 = file.getName();
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("deleteStaleDirectories checking ", string2);
            }
            if (file.isFile()) {
                if (CommonDirectory.isCommonControlFile(string2) || !string2.startsWith(TRASH_PREFIX)) continue;
                IPC.logMessage("delete trash file ", string2);
                if (file.delete()) continue;
                IPC.logMessage("error deleting ", string2);
                continue;
            }
            if (string2.equalsIgnoreCase(string)) continue;
            if (Character.isDigit(string2.charAt(0))) {
                try {
                    l2 = Long.parseLong(string2);
                    long l3 = CommonDirectory.getFileOwner(file.getAbsolutePath());
                    if (0L != l && l3 != l) {
                        l2 = 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    l2 = CommonDirectory.getPidFromFile(file, l);
                }
            } else {
                l2 = CommonDirectory.getPidFromFile(file, l);
            }
            if (0L == l2 || IPC.processExists(l2)) continue;
            IPC.logMessage("delete defunct directory ", string2);
            TargetDirectory.deleteTargetDirectory(string2);
        }
    }

    public static boolean isFileOwnedByUid(File file, long l) {
        return 0L == l || l == CommonDirectory.getFileOwner(file.getAbsolutePath());
    }

    private static long getPidFromFile(File file, long l) {
        Advertisement advertisement;
        long l2 = 0L;
        File file2 = new File(file, Advertisement.getFilename());
        if (!file2.exists() || 0L == file2.length()) {
            IPC.logMessage("delete stale directory ", file.getName());
            TargetDirectory.deleteTargetDirectory(file.getName());
        }
        try (FileInputStream fileInputStream = new FileInputStream(file2);){
            advertisement = Advertisement.readAdvertisementFile(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return 0L;
        }
        l2 = advertisement.getProcessId();
        long l3 = advertisement.getUid();
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("getPidFromFile pid = ", (int)l2, file.getName());
        }
        if (0L == l3) {
            l3 = CommonDirectory.getFileOwner(file.getAbsolutePath());
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("getPidFromFile uid = ", (int)l3);
        }
        if (0L != l && l3 != l) {
            l2 = 0L;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileLock getAttachLock() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == attachLock) {
                attachLock = new FileLock(new File(CommonDirectory.getCommonDirFileObject(), ATTACH_LOCK).getAbsolutePath(), 438);
            }
        }
        return attachLock;
    }

    private static FileLock getMasterLock() {
        if (null == masterLock) {
            File file = new File(CommonDirectory.getCommonDirFileObject(), MASTER_LOCKFILE);
            String string = file.getAbsolutePath();
            masterLock = new FileLock(string, 438);
        }
        return masterLock;
    }

    public static native long getFileOwner(String var0);

    static {
        masterLockCount = 0;
        systemTmpDir = IPC.getTmpDir();
    }

    static final class DirectorySampler
    implements FileFilter {
        private int acceptCount = 16;
        private long skip;
        private long range = 2L;

        DirectorySampler() {
        }

        @Override
        public boolean accept(File file) {
            if (this.acceptCount > 0) {
                --this.acceptCount;
                return true;
            }
            if (this.skip > 0L) {
                --this.skip;
                return false;
            }
            this.skip = System.currentTimeMillis() % this.range;
            this.range *= 2L;
            return true;
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

