/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.UnknownHostException;
import sun.security.krb5.internal.NetClient;

class UDPClient
extends NetClient {
    InetAddress iaddr;
    int iport;
    int bufSize = 65507;
    DatagramSocket dgSocket;
    DatagramPacket dgPacketIn;

    UDPClient(String string, int n, int n2) throws UnknownHostException, SocketException {
        this.iaddr = InetAddress.getByName(string);
        this.iport = n;
        this.dgSocket = new DatagramSocket();
        this.dgSocket.setSoTimeout(n2);
        this.dgSocket.connect(this.iaddr, this.iport);
    }

    @Override
    public void send(byte[] byArray) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.iaddr, this.iport);
        this.dgSocket.send(datagramPacket);
    }

    @Override
    public byte[] receive() throws IOException {
        byte[] byArray = new byte[this.bufSize];
        this.dgPacketIn = new DatagramPacket(byArray, byArray.length);
        try {
            this.dgSocket.receive(this.dgPacketIn);
        }
        catch (SocketException socketException) {
            if (socketException instanceof PortUnreachableException) {
                throw socketException;
            }
            this.dgSocket.receive(this.dgPacketIn);
        }
        byte[] byArray2 = new byte[this.dgPacketIn.getLength()];
        System.arraycopy((Object)this.dgPacketIn.getData(), 0, (Object)byArray2, 0, this.dgPacketIn.getLength());
        return byArray2;
    }

    @Override
    public void close() {
        this.dgSocket.close();
    }
}

