/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class AIXDumpReaderFactory
implements ICoreFileReader {
    @Override
    public ICore processDump(String string) throws InvalidDumpFormatException, IOException {
        return AIXDumpReader.getReaderForFile(new File(string));
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        byte[] byArray = CoreReader.getFileHeader(string);
        return AIXDumpReader.isAIXDump(byArray, file.length()) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = CoreReader.getFileHeader(imageInputStream);
        return AIXDumpReader.isAIXDump(byArray, Long.MAX_VALUE) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    @Override
    public ICore processDump(ImageInputStream imageInputStream) throws InvalidDumpFormatException, IOException {
        return AIXDumpReader.getReaderForFile(imageInputStream);
    }
}

