/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import java.util.Properties;

public class J9DDRImageSection
implements ImageSection {
    private final IProcess proc;
    private final long address;
    private J9DDRImagePointer baseAddress = null;
    private long size = 0L;
    private final String name;

    public J9DDRImageSection(IProcess iProcess, long l, String string) {
        this.proc = iProcess;
        this.address = l;
        this.name = string != null ? string : "Image section @ " + Long.toHexString(this.getBaseAddress().getAddress());
    }

    public J9DDRImageSection(IProcess iProcess, long l, long l2, String string) {
        this.proc = iProcess;
        this.address = l;
        this.size = l2;
        this.name = string != null ? string : "Image section @ " + Long.toHexString(l) + " (" + this.getSize() + " bytes)";
    }

    public J9DDRImagePointer getBaseAddress() {
        if (this.baseAddress == null) {
            this.baseAddress = new J9DDRImagePointer(this.proc, this.address);
        }
        return this.baseAddress;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isExecutable() throws DataUnavailable {
        return this.getBaseAddress().isExecutable();
    }

    public boolean isReadOnly() throws DataUnavailable {
        return this.getBaseAddress().isReadOnly();
    }

    public boolean isShared() throws DataUnavailable {
        return this.getBaseAddress().isShared();
    }

    public Properties getProperties() {
        return this.getBaseAddress().getProperties();
    }

    public void setSize(long l) {
        this.size = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ImageSection [0x");
        stringBuilder.append(Long.toHexString(this.address));
        stringBuilder.append(" - 0x");
        stringBuilder.append(Long.toHexString(this.address + this.size));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

