/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.SystemMonitorSingleTier_V1;
import com.ibm.j9ddr.vm29.j9.SystemMonitorThreeTier_V1;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OmrBuildFlags;
import java.util.List;

public abstract class SystemMonitor
implements Comparable<SystemMonitor> {
    protected J9ThreadMonitorPointer monitor;

    public static SystemMonitor fromJ9ThreadMonitor(J9ThreadMonitorPointer j9ThreadMonitorPointer) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_OBJECT_MONITOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        if (OmrBuildFlags.OMR_THR_THREE_TIER_LOCKING) {
            return new SystemMonitorThreeTier_V1(j9ThreadMonitorPointer);
        }
        return new SystemMonitorSingleTier_V1(j9ThreadMonitorPointer);
    }

    public J9ThreadMonitorPointer getRawMonitor() {
        return this.monitor;
    }

    @Override
    public int compareTo(SystemMonitor systemMonitor) {
        return this.monitor.compare(systemMonitor.monitor);
    }

    public boolean equals(Object object) {
        return this.compareTo((SystemMonitor)object) == 0;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public J9ThreadPointer getOwner() throws CorruptDataException {
        return this.monitor.owner();
    }

    public String getName() {
        String string = "<unnamed monitor>";
        try {
            if (this.monitor.name().notNull()) {
                string = String.format("\"%s\"", this.monitor.name().getCStringAtOffset(0L));
            }
        }
        catch (CorruptDataException corruptDataException) {
            string = "<FAULT>";
        }
        return string;
    }

    public long getCount() throws CorruptDataException {
        return this.monitor.count().longValue();
    }

    public abstract boolean isContended() throws CorruptDataException;

    public abstract List<J9ThreadPointer> getWaitingThreads() throws CorruptDataException;

    public abstract List<J9ThreadPointer> getBlockedThreads() throws CorruptDataException;
}

