/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySubSpacePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.NoSuchElementException;

public class GCHeapRegionIterator
extends GCIterator {
    private MM_MemorySpacePointer _space;
    private MM_HeapRegionDescriptorPointer _auxRegion;
    private MM_HeapRegionDescriptorPointer _tableRegion;
    private MM_HeapRegionManagerPointer _regionManager;
    private long _tableDescriptorSize;
    private GCHeapRegionDescriptor currentRegion;

    protected GCHeapRegionIterator(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer, MM_MemorySpacePointer mM_MemorySpacePointer, boolean bl, boolean bl2) throws CorruptDataException {
        this._regionManager = mM_HeapRegionManagerPointer;
        this._space = mM_MemorySpacePointer;
        if (bl2) {
            this._auxRegion = this._regionManager._auxRegionDescriptorList();
            if (this._auxRegion.isNull()) {
                this._auxRegion = null;
            }
        }
        if (bl) {
            this._tableRegion = this._regionManager._regionTable();
            if (this._tableRegion.isNull()) {
                this._tableRegion = null;
            }
            this._tableDescriptorSize = this._regionManager._tableDescriptorSize().longValue();
        }
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer, MM_MemorySpacePointer mM_MemorySpacePointer, boolean bl, boolean bl2) throws CorruptDataException {
        return new GCHeapRegionIterator(mM_HeapRegionManagerPointer, mM_MemorySpacePointer, bl2, bl);
    }

    public static GCHeapRegionIterator from() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = mM_GCExtensionsPointer.heapRegionManager();
        return GCHeapRegionIterator.fromMMHeapRegionManager(mM_HeapRegionManagerPointer, true, true);
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer, MM_MemorySpacePointer mM_MemorySpacePointer) throws CorruptDataException {
        return new GCHeapRegionIterator(mM_HeapRegionManagerPointer, mM_MemorySpacePointer, true, true);
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer, boolean bl, boolean bl2) throws CorruptDataException {
        return new GCHeapRegionIterator(mM_HeapRegionManagerPointer, null, bl, bl2);
    }

    protected boolean shouldIncludeRegion(MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer) throws CorruptDataException {
        if (null != this._space) {
            MM_MemorySubSpacePointer mM_MemorySubSpacePointer = mM_HeapRegionDescriptorPointer._memorySubSpace();
            if (mM_MemorySubSpacePointer.notNull()) {
                return this._space.eq(mM_MemorySubSpacePointer._memorySpace());
            }
            return false;
        }
        return true;
    }

    protected MM_HeapRegionDescriptorPointer getNextAuxiliaryRegion(MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer) throws CorruptDataException {
        MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer2 = mM_HeapRegionDescriptorPointer._nextRegion();
        if (mM_HeapRegionDescriptorPointer2.isNull()) {
            return null;
        }
        return mM_HeapRegionDescriptorPointer2;
    }

    protected MM_HeapRegionDescriptorPointer getNextTableRegion(MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer) throws CorruptDataException {
        MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer2 = mM_HeapRegionDescriptorPointer.addOffset(this._tableDescriptorSize * mM_HeapRegionDescriptorPointer._regionsInSpan().longValue());
        if (mM_HeapRegionDescriptorPointer2.isNull()) {
            return null;
        }
        MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer3 = MM_HeapRegionDescriptorPointer.cast(this._regionManager._regionTable().longValue() + this._tableDescriptorSize * this._regionManager._tableRegionCount().longValue());
        MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer4 = MM_HeapRegionDescriptorPointer.NULL;
        MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer5 = mM_HeapRegionDescriptorPointer2;
        while (mM_HeapRegionDescriptorPointer4.isNull() && mM_HeapRegionDescriptorPointer5.lt(mM_HeapRegionDescriptorPointer3)) {
            if (mM_HeapRegionDescriptorPointer5._isAllocated()) {
                mM_HeapRegionDescriptorPointer4 = mM_HeapRegionDescriptorPointer5;
                continue;
            }
            mM_HeapRegionDescriptorPointer5 = mM_HeapRegionDescriptorPointer5.addOffset(this._tableDescriptorSize * mM_HeapRegionDescriptorPointer5._regionsInSpan().longValue());
        }
        if (mM_HeapRegionDescriptorPointer4.isNull()) {
            return null;
        }
        return mM_HeapRegionDescriptorPointer4;
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.currentRegion) {
                return true;
            }
            while (null != this._auxRegion || null != this._tableRegion) {
                MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer = null;
                if (null != this._auxRegion && (null == this._tableRegion || this._auxRegion.lt(this._tableRegion))) {
                    mM_HeapRegionDescriptorPointer = this._auxRegion;
                    this._auxRegion = this.getNextAuxiliaryRegion(this._auxRegion);
                } else {
                    if (null == this._tableRegion) break;
                    mM_HeapRegionDescriptorPointer = this._tableRegion;
                    this._tableRegion = this.getNextTableRegion(this._tableRegion);
                }
                if (!this.shouldIncludeRegion(mM_HeapRegionDescriptorPointer)) continue;
                this.currentRegion = GCHeapRegionDescriptor.fromHeapRegionDescriptor(mM_HeapRegionDescriptorPointer);
                return true;
            }
            return false;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return false;
        }
    }

    @Override
    public GCHeapRegionDescriptor next() {
        if (this.hasNext()) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor = this.currentRegion;
            this.currentRegion = null;
            return gCHeapRegionDescriptor;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

