/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ArgBits;
import com.ibm.j9ddr.vm29.j9.PCStack;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.localmap");
    public static final int ENCODED_INDEX = 4;
    public static final int ENCODED_MASK = 3;
    public static final int WIDE_INDEX = 8;
    public static final int DOUBLE_ACCESS = 32;
    public static final int SINGLE_ACCESS = 64;
    public static final int OBJECT_ACCESS = 128;
    public static final int WRITE_ACCESS = 16;
    public static final int INT = 0;
    public static final int OBJ = 1;
    public static final int NOT_FOUND = -1;
    public static final int WALKED = 1;
    private static LocalMapImpl impl = null;

    public static void j9localmap_ArgBitsForPC0(J9ROMMethodPointer j9ROMMethodPointer, int[] nArray) throws CorruptDataException {
        LocalMap.getImpl().j9localmap_ArgBitsForPC0(j9ROMMethodPointer, nArray);
    }

    public static int j9localmap_LocalBitsForPC(J9ROMMethodPointer j9ROMMethodPointer, UDATA uDATA, int[] nArray) throws CorruptDataException {
        return LocalMap.getImpl().j9localmap_LocalBitsForPC(j9ROMMethodPointer, uDATA, nArray);
    }

    private static LocalMapImpl getImpl() {
        if (impl == null) {
            impl = LocalMap.getImpl("ALG_LOCAL_MAP_VERSION");
        }
        return impl;
    }

    private static LocalMapImpl getImpl(String string) {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf(string);
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new LocalMap_V1();
    }

    private static class LocalMap_V1
    implements LocalMapImpl {
        private boolean unknownsWereUpdated = false;
        private int knownLocals = 0;
        private int knownObjects = 0;

        protected LocalMap_V1() {
        }

        @Override
        public void j9localmap_ArgBitsForPC0(J9ROMMethodPointer j9ROMMethodPointer, int[] nArray) throws CorruptDataException {
            ArgBits.argBitsFromSignature(J9UTF8Helper.stringValue(ROMHelp.J9ROMMETHOD_SIGNATURE(j9ROMMethodPointer)), nArray, ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer).add(31).rightShift(5).intValue(), j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic));
        }

        @Override
        public int j9localmap_LocalBitsForPC(J9ROMMethodPointer j9ROMMethodPointer, UDATA uDATA, int[] nArray) throws CorruptDataException {
            UDATA uDATA2 = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer).add(31))).rightShift(5);
            Arrays.fill(nArray, 0, uDATA2.intValue() - 1, 0);
            UDATA uDATA3 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            int[] nArray2 = new int[uDATA3.intValue()];
            this.mapAllLocals(j9ROMMethodPointer, nArray2, uDATA, nArray);
            return 0;
        }

        private void mapAllLocals(J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, UDATA uDATA, int[] nArray2) throws CorruptDataException {
            J9ExceptionInfoPointer j9ExceptionInfoPointer = null;
            J9ExceptionHandlerPointer j9ExceptionHandlerPointer = null;
            UDATA uDATA2 = new UDATA(0L);
            UDATA uDATA3 = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer)));
            int n = 0;
            int n2 = 0;
            if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo)) {
                j9ExceptionInfoPointer = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer);
                uDATA2 = new UDATA(j9ExceptionInfoPointer.catchCount());
            }
            while (uDATA3.gt(0)) {
                Arrays.fill(nArray, 0, ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer).intValue() - 1, 0);
                this.knownLocals = 0;
                if (uDATA3.gt(32)) {
                    uDATA3 = uDATA3.sub(32L);
                } else {
                    if (uDATA3.lt(new U32(32L))) {
                        this.knownLocals = -1;
                        this.knownLocals <<= uDATA3.intValue();
                    }
                    uDATA3 = new UDATA(0L);
                }
                this.knownObjects = 0;
                this.mapLocalSet(j9ROMMethodPointer, nArray, uDATA, n2);
                if (this.knownLocals != -1 && uDATA2.gt(0)) {
                    boolean bl = true;
                    int n3 = 0;
                    while (bl) {
                        bl = false;
                        j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(j9ExceptionInfoPointer);
                        for (int i = 0; i < uDATA2.intValue(); ++i) {
                            int n4;
                            int n5;
                            n3 = 0;
                            Object object = j9ExceptionHandlerPointer.startPC();
                            while (((UScalar)object).lt(j9ExceptionHandlerPointer.endPC())) {
                                n3 |= nArray[((UDATA)object).intValue()];
                                object = ((UDATA)object).add(1L);
                            }
                            int n6 = n3;
                            n3 &= ~this.knownLocals;
                            if (logger.isLoggable(Level.FINER)) {
                                object = new StringBuffer();
                                ((StringBuffer)object).append(String.format("handler[%d] unknowns raw=0x%X masked=0x%X [", i, n6, n3));
                                for (n5 = 0; n5 < 32; ++n5) {
                                    n4 = 1 << n5;
                                    if ((n3 & n4) == 0) continue;
                                    ((StringBuffer)object).append(String.format("%d ", n5 + n2));
                                }
                                ((StringBuffer)object).append("]");
                                logger.logp(Level.FINER, "LocalMap", "mapAllLocals", ((StringBuffer)object).toString());
                            }
                            if ((~nArray[j9ExceptionHandlerPointer.handlerPC().intValue()] & n3) != 0) {
                                int n7 = this.knownLocals;
                                n5 = this.knownLocals = ~n3;
                                this.unknownsWereUpdated = false;
                                this.mapLocalSet(j9ROMMethodPointer, nArray, new UDATA(j9ExceptionHandlerPointer.handlerPC()), n2);
                                n4 = this.knownLocals;
                                this.knownLocals = n7;
                                bl = bl || n4 != n5;
                                bl = bl || this.unknownsWereUpdated;
                                this.knownLocals |= n4 & ~n5;
                            }
                            j9ExceptionHandlerPointer = j9ExceptionHandlerPointer.add(1L);
                        }
                    }
                }
                nArray2[n] = this.knownObjects;
                ++n;
                n2 += 32;
            }
        }

        private int mapLocalSet(J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, UDATA uDATA, int n) throws CorruptDataException {
            int n2 = ~this.knownLocals;
            Stack<BranchState> stack = new Stack<BranchState>();
            this.unknownsWereUpdated = false;
            U8Pointer u8Pointer = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
            U8Pointer u8Pointer2 = u8Pointer.add(ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer));
            U8Pointer u8Pointer3 = u8Pointer.add(uDATA);
            while (u8Pointer3.lt(u8Pointer2)) {
                int n3;
                boolean bl;
                int n4 = (int)(u8Pointer3.getAddress() - u8Pointer.getAddress());
                boolean bl2 = bl = (~nArray[n4] & n2) != 0;
                if (logger.isLoggable(Level.FINER)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.format("pc=%d walk=%s seekLocals=0x%X [", n4, bl ? "true" : "false", n2));
                    for (n3 = 0; n3 < 32; ++n3) {
                        int n5 = 1 << n3;
                        if ((n2 & n5) == 0) continue;
                        stringBuffer.append(String.format("%d ", n3));
                    }
                    stringBuffer.append("]");
                    logger.logp(Level.FINER, "LocalMap", "mapLocalSet", stringBuffer.toString());
                }
                if ((~nArray[n4] & n2) != 0) {
                    this.unknownsWereUpdated = true;
                    int n6 = n4;
                    nArray[n6] = nArray[n6] | n2;
                    UDATA uDATA2 = new UDATA(u8Pointer3.at(0L));
                    UDATA uDATA3 = new UDATA(0xFF & PCStack.J9JavaInstructionSizeAndBranchActionTable[uDATA2.intValue()]);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "bcIndex={0}, bc={1}, size={2}", new Object[]{Long.toHexString(u8Pointer3.getAddress()), uDATA2, uDATA3});
                    }
                    switch (uDATA3.intValue() >>> 4) {
                        case 0: {
                            UDATA uDATA4 = new UDATA(PCStack.J9BytecodeSlotUseTable[uDATA2.intValue()]);
                            if (uDATA4.longValue() != 0L) {
                                U32 u32;
                                if (uDATA4.anyBitsIn(4L)) {
                                    u32 = new U32(uDATA4.bitAnd(3));
                                } else {
                                    u32 = new U32(MapHelpers.PARAM_8(u8Pointer3, 1));
                                    if (uDATA4.anyBitsIn(8L)) {
                                        u32 = new U32(MapHelpers.PARAM_16(u8Pointer3, 1));
                                    }
                                }
                                u32 = u32.sub(n);
                                n3 = 1;
                                while (n3 != 0) {
                                    if (u32.lt(new UDATA(32L))) {
                                        int n7 = 1 << u32.intValue();
                                        if ((n2 & n7) != 0) {
                                            n2 &= ~n7;
                                            logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  stop looking for local={0}", u32);
                                            if (!uDATA4.anyBitsIn(16L)) {
                                                this.knownLocals |= n7;
                                                logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  add local={0} to known locals.", u32);
                                                if (uDATA4.anyBitsIn(128L)) {
                                                    this.knownObjects |= n7;
                                                    logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  add local={0} to known objects.", u32);
                                                }
                                            }
                                        } else {
                                            logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  skipping reference to local={0}", u32);
                                        }
                                    }
                                    if (uDATA4.anyBitsIn(32L)) {
                                        uDATA4 = uDATA4.bitAnd(new UDATA(32L).bitNot());
                                        u32 = u32.add(1);
                                        continue;
                                    }
                                    n3 = 0;
                                }
                            }
                            u8Pointer3 = u8Pointer3.add(uDATA3);
                            break;
                        }
                        case 1: {
                            I32 i32 = new I32(new I16(MapHelpers.PARAM_16(u8Pointer3, 1)));
                            stack.push(new BranchState(n4 + i32.intValue(), n2));
                        }
                        case 6: {
                            u8Pointer3 = u8Pointer3.add(uDATA3.bitAnd(7));
                            break;
                        }
                        case 2: {
                            UDATA uDATA5;
                            I32 i32;
                            if (uDATA2.intValue() == 167) {
                                i32 = new I32(new I16(MapHelpers.PARAM_16(u8Pointer3, 1)));
                                uDATA5 = new UDATA(n4).add(i32);
                            } else {
                                i32 = new I32(MapHelpers.PARAM_32(u8Pointer3, 1));
                                uDATA5 = new UDATA(n4).add(i32);
                            }
                            u8Pointer3 = u8Pointer.add(uDATA5);
                            break;
                        }
                        case 4: {
                            if (stack.empty()) {
                                return 0;
                            }
                            BranchState branchState = (BranchState)stack.pop();
                            n4 = branchState.programCounter;
                            n2 = branchState.seekLocals;
                            n2 &= ~this.knownLocals;
                            u8Pointer3 = u8Pointer.add(n4);
                            break;
                        }
                        case 5: {
                            U32 u32;
                            UDATA uDATA4;
                            u8Pointer3 = u8Pointer3.add(4 - (n4 & 3));
                            I32 i32 = new I32(MapHelpers.PARAM_32(u8Pointer3, 0));
                            u8Pointer3 = u8Pointer3.add(4L);
                            UDATA uDATA5 = new UDATA(n4).add(i32);
                            I32 i322 = new I32(MapHelpers.PARAM_32(u8Pointer3, 0));
                            u8Pointer3 = u8Pointer3.add(4L);
                            if (uDATA2.intValue() == 170) {
                                I32 i323 = new I32(MapHelpers.PARAM_32(u8Pointer3, 0));
                                u8Pointer3 = u8Pointer3.add(4L);
                                u32 = new U32(i323.sub(i322).add(1L));
                                uDATA4 = new UDATA(0L);
                            } else {
                                u32 = new U32(i322);
                                uDATA4 = new UDATA(4L);
                            }
                            while (u32.gt(0)) {
                                u8Pointer3 = u8Pointer3.add(uDATA4);
                                i32 = new I32(MapHelpers.PARAM_32(u8Pointer3, 0));
                                u8Pointer3 = u8Pointer3.add(4L);
                                stack.add(new BranchState(n4 + i32.intValue(), n2));
                                u32 = u32.sub(1);
                            }
                            u8Pointer3 = u8Pointer.add(uDATA5);
                        }
                    }
                    continue;
                }
                if (stack.empty()) {
                    return 0;
                }
                BranchState branchState = (BranchState)stack.pop();
                n4 = branchState.programCounter;
                n2 = branchState.seekLocals;
                n2 &= ~this.knownLocals;
                u8Pointer3 = u8Pointer.add(n4);
            }
            return 0;
        }
    }

    private static class BranchState {
        public final int seekLocals;
        public final int programCounter;

        public BranchState(int n, int n2) {
            this.seekLocals = n2;
            this.programCounter = n;
        }
    }

    private static interface LocalMapImpl {
        public void j9localmap_ArgBitsForPC0(J9ROMMethodPointer var1, int[] var2) throws CorruptDataException;

        public int j9localmap_LocalBitsForPC(J9ROMMethodPointer var1, UDATA var2, int[] var3) throws CorruptDataException;
    }
}

